<?php
/**
 * Objet de base pour la cr�ation de pages d'Astairs.
 * Cette Objet est dedi� uniquement pour la construction de fin de page des �l�ments Contrib
 */
class AstairsPageContribFin extends AstairsTemplate{
	
	var $pageBuilder;

	/**
	 * Constructeur.
	 * @param object PageBuilder $pageBuilder L'objet permettant de cr�er une page
	 * @param Array $templates Les templates � utiliser pour la cr�ation de la page
	 * @param Array $style_files Les feuilles de style
	 */
	function AstairsPageContribFin($pageBuilder,$templates){

		global $serverfront,$nom_site_front;
		
		//parent
		parent::Template($pageBuilder->getRoot());
		
		//affectation des attributs
		$this->pageBuilder=$pageBuilder;
		$this->pageComponents=array();
//print_rr($this->pageBuilder);
		//inclusion de tout les templates n�cessaires
		parent::set_file($this->pageBuilder->getRequiredTemplates()); //templates communs
		
		parent::set_root($this->pageBuilder->getModuleRoot());
		parent::set_file($templates); //templates de la page
	}	
	
	function parse(){
		if ($this->debug & 1) {
			printf("<b>AstairsPage::parse()</b><br>\n");
		}
		//on parse chacun des components
		foreach($this->pageComponents as  $target=> $compts){
			foreach($compts as $ind_comp => $component){
				if ($this->debug & 4) {
					printf("Call of: (%s) AstairsPage/AstairsTemplate::parseComponents(%s,%s): <br>\n",get_class($component),get_class($component),true);
				}	
				//le parsing d'un component consiste � parser 'target' et le stocker dans 'TARGET'
				$component->parseComponents($target,true);
				
				if ($this->debug & 4) {
					printf("Call of: (%s) AstairsPage/AstairsTemplate::parseBlocks(%s,%s): <br>\n",get_class($component),$target,true);
				}	
				$component->parseBlocks($target,true);
				
				if ($this->debug){
					print_rr($component->get_undefined(strtoupper($target)));
				}
				
				
				if ($this->debug & 4) {
					printf("Call of: (%s) AstairsPage/AstairsTemplate::parseComponent(%s,%s,%s): <br>\n",get_class($component),strtoupper($target), $component->get_var(strtoupper($target)),true);
				}	
				//le resultat du parsing du component(component.'TARGET') sert ensuite � valuer this.'TARGET'
				$this->parseComponent(strtoupper($target), $component->get_var(strtoupper($target)),true);
			}
		}
//		
		parent::parse('PIED_PAGE', 'pied_page');
		parent::parse('page_content_fin', 'content_fin');
		
//		if ($this->debug){
//			print_rr(parent::get_undefined('page_content_fin'));
//		}
	}
	
//	function set_block(){
//		die("Erreur: Vous ne pouvez pas cr�er de block directement dans une AstairsPage. Utilisez un PageComponent.<br>");
//	}
//	
	function p(){
		parent::p('page_content_fin');
	}
//	
//	/**
//	 * This is shorthand for print $this->parse(...) and is functionally identical.
//	 * See parse for further details.
//	 *
//	 * Returns: always returns false.
//	 *
//	 * usage: pparse(string $target, string $varname, [boolean $append])
//	 * or
//	 * usage: pparse(string $target, array $varname = (string $varname), [boolean $append])
//	 *
//	 * @param     $target      a string containing the name of the variable into which substituted $varnames are to be stored
//	 * @param     $varname     if a string, the name the name of the variable to substitute or if an array a list of variables to be substituted
//	 * @param     $append      if true, the substituted variables are appended to $target otherwise the existing value of $target is replaced
//	 * @access    public
//	 * @return    false
//	 * @see       parse
//	 */
//	function pparse($target, $varname, $append = false) {
//		if ($this->debug & 4) {
//			echo "<p><b>pparse:</b> passing parameters to parse...</p>\n";
//		}
//		print $this->finish($this->parse($target, $varname, $append));
//		return false;
//	}
}
?>