<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @param DoEtape $sz_obj_doetape Objet d'avancement de l'�tape
 * 
 * @package etape
 */

//----------------------------------------------------------
//					INCLUSIONS
//----------------------------------------------------------
//EN TETE DE LA PAGE
$dbpath="../..";
include("$dbpath/en_tete.php");

include("../en_tete_front.php");

include("./includes.php");
//$NIVEAU_DEBUG=1;
ob_start();

//-----------------------------------------------------------
//					Initialisation objet DoEtape
//-----------------------------------------------------------
//on recupere l'objet d'avancement de l'URL (Etape libre ou d�j� faite)
if(!empty($sz_obj_doetape)){
	$obj_DoEtape_URL=importObject($sz_obj_doetape);
	$obj_DoEtape=&$obj_DoEtape_URL;
	messageDebugR("Recup�ration de l'�tape de l'URL",$obj_DoEtape);
}

//on recupere l'objet d'avancement de la session (Etape courante)
$obj_DoEtape_SESSION=&$obj_DoFormation->getCurrentDoEtape();
if(is_object($obj_DoEtape_SESSION)){
	if($obj_DoEtape_URL){
		if($obj_DoEtape_SESSION->compareTo($obj_DoEtape_URL)){
			$obj_DoEtape=&$obj_DoEtape_SESSION;
		}
	}
	else{
		$obj_DoEtape=&$obj_DoEtape_SESSION;
	}
	messageDebugR("Recup�ration de l'�tape de la session",$obj_DoEtape);
}
else{
	 $obj_DoEtape=&$obj_DoEtape_URL;
}

messageDebugR("Etape choisie:",$obj_DoEtape);	

//traitement de l'objet DoEtape
if(is_object($obj_DoEtape)){
	
	//debut de l'�tape	
	if(!$obj_DoEtape->isBegin()&&!$obj_DoEtape->isEnd()){
		$obj_DoEtape->beginCurrentEtape();
	}
	
	//recup de l'objet �tape
	$obj_DoEtape->performCurrentEtape(new EtapeFactory());
	$obj_etape=& $obj_DoEtape->getObjEtape();
	$parcours=$obj_DoEtape->getParcours();
	$formation=$obj_DoEtape->getFormation();
	$individu=$obj_DoEtape->getIndividu();
	if(is_object($obj_etape)){
	
		$id=$obj_etape->getId();
		$type=$obj_etape->getType();
		if(empty($id)||empty($type)){
			die("Erreur etape.php: valeurs manquantes:\$id=$id<br>  \$type=$type<br>");	
		}
		
	}else{
		die("Erreur etape.php: il n'y a pas d'�tape � afficher(Etape).");
	}
}else{
	die("Erreur etape.php: il n'y a pas d'�tape � effectuer.(DoEtape)");
}

//-----------------------------------------------------------
//					AFFICHAGE ETAPE
//-----------------------------------------------------------

$page_builder->setModuleRoot("$chemin_fo/module/templates/tpl");
	
//les styles
//$liste_style_files=list_file($page_builder->getStylePath());
//foreach($liste_style_files as $s=>$style_file){
//	foreach($style_file as $style_file_path=>$style_file_name){
//		$style_files[$style_file_path][]=$style_file_name;	
//	}
//}
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='style_globale.css';
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='parcours.css';
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='etape.css';
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='etape_serie.css';
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='etape_do_liste.css';
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='etape_do_chat.css';
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='etape_do_serie.css';
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='evaluation.css';
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='etape_do_exotlc.css';
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='etape_do_ressource.css';
$style_files[$dbpath.'/fo/styles/'.$style_par_defaut][]='etape_forum.css';

messageDebugR("Fichier CSS charg�s:",$style_files);	
	
//les fichiers javascripts
//$javascript_files=array();
$javascript_files["./templates/script"][]="javascript_etape.js";
$javascript_files["../etape_ressource/templates/script"][]="javascript_etape_ressource_texte.js";
$javascript_files["../../lib_graphique/javascript/contrib/FLVPlayerMulti/script"][]="FLVPlayerControls.js";
messageDebugR("Fichier javascript charg�s:",$javascript_files);	

//le javascript interne
messageDebug("Code javascript charg�:<br>$javascript_internal_code");	


//les �l�ments pour la page
$page_debut = new ModulePageDebut($MSG_1033,$force_no_end,$obj_DoEtape,$formation,$page_builder->getModuleRoot(),array('page_debut' => 'module_page_debut.tpl'));

$page_contenu=new ModulePageDoEtape($force_no_end,$obligatoire,$obj_DoFormation,$obj_DoEtape,new EtapePageFactory(),$page_builder->getModuleRoot(),array('page_contenu' => 'module_page_contenu.tpl'));

$page_fin = new ModulePageFin($page_builder->getModuleRoot(),array('page_fin' => 'module_page_fin.tpl'));

//la page sp�cifique	
$page=new ModulePage($page_builder, array('page_dev' => 'module_page.tpl'),$style_files,$javascript_files,$javascript_internal_code);

//fermeture popup pour etape chat
if(get_class($obj_DoEtape)=='doetapechat'){
	$page->setOnUnLoad('close_popup();');
}
//affectation des �l�ments
$page->setComponent('page_debut', $page_debut);
$page->setComponent('page_contenu', $page_contenu);
$page->setComponent('page_fin',$page_fin);
//print_rr($obj_DoEtape);
$debug=ob_get_contents();
ob_end_clean();
$page->parse();

//on affiche
$page->p();
echo "$debug";

include("../pied_page.php");
?>