<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class permettant la creation d'une etape selon son type
 * 
 * @package Etape
 */
class EtapePageFactory{
	
	/**
	 * Cre et retourne une EtapePage.
	 * Note: Cette mthode construit une EtapePage en fonction du type d'une Etape, la stocke dans une variable '$etape_page' et la retourne.
	 * 
	 * @param $target_component Variable du tpl pre ou sont stocks les lments pour l'affichage
	 * @param $type_court Variable ou est stock le type format.
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une tape.
	 * @param object[] $obj_DoFormation Objet contenant toutes les informations de la formation.
	 * @param boolean $obligatoire Indique si l'tape est obligatoire ou non.
	 * @param boolean $force_no_end Force  ne pas finir l'tape.
	 * 
	 * @return PageComponent L'EtapePage.
	 */
	function createEtapePage($target_component, $type_court,$obj_DoEtape,$obj_DoFormation,$obligatoire,$force_no_end){
		global $chemin_fo,$root;	
	//print_rr($obj_DoEtape);
		
		switch($type_court){
			//
			case TYPE_ETAPE_FORUM:
				//---------------------------------------------------------------
				// DEFINITION/DECLARATION/INCLUSIONS DES VARIABLES POUR LE guiExternalContent()
				//---------------------------------------------------------------				
				
				//base de donnes
				global $adressebase, $nombase,$login,$pass;
				global $db_name, $db_user, $db_pass, $db_host;
				$db_name=$nombase;
				$db_user=$login;
				$db_pass=$pass;
				$db_host=$adressebase;
				
				//---------------------------------------------------------------
				// Le guiExternalContent() permettant le stockage de l'affichage d'un script php dans un AstairsTemplate
				//---------------------------------------------------------------	
				$etape_page= new guiExternalContent($target_component,$obj_DoFormation,"$chemin_fo/etape_forum/etape_forum.php");
				break;
			
			case TYPE_ETAPE_SCORM:
				include("$chemin_fo/scorm/scorm.php");
				break;
			
			case TYPE_ETAPE_LISTE:
	
//				echo"$type_court";
				$type_liste=get_etape_type_formate($type_court,2); 
				
				switch($type_liste){
					
					case TYPE_ETAPE_LISTE:
//					include("$chemin_fo/serie/includes.php");
//					$etape_page= new guiFoSerie("$chemin_fo/etape/templates/tpl",array($target_component => 'etape_page.tpl'));
						
					case TYPE_ETAPE_LISTE.'_'.TYPE_LISTE_SERIE:
						include("$chemin_fo/serie/includes.php");
						$etape_page= new guiFoSerie($obj_DoEtape,"$chemin_fo/etape/templates/tpl",array($target_component => 'gui_fo_do_etape.tpl'));
						break;
					
					case TYPE_ETAPE_LISTE.'_'.TYPE_LISTE_TEST:
						include("$chemin_fo/test/test.php");
						break;
					default:
					die("Erreur etape.php: Le type de liste  '$type_liste' n'a pas de scripts d'execution associ.");	
				}
				break;
			
			
			case TYPE_ETAPE_EXOTLC:
//				$nompage="index.php3/exotlc";
//				$texte="&nbsp;";
//				$image="ongl_exotlc.gif";
//				if($obj_etape->getTypeRendu()==TYPE_EXOTLC_PLATEFORME){
//					$force_no_end=true;	
//				}else{
//					$force_no_end=false;	
//				}
//				include("$chemin_fo/en_tete.php");
//				include("$chemin_fo/exotlc/exotlc.php");
				global $chemin_bo;
				include("$chemin_fo/exotlc/includes.php");
				$etape_page= new guiFoExotlcPage($obj_DoEtape,"$chemin_fo/etape/templates/tpl",array($target_component => 'gui_fo_do_etape.tpl'));
				break;
					
			
			case TYPE_ETAPE_SCENARIO:
				include("$chemin_fo/scenario/includes.php");
				$etape_page= new guiFoScenario($force_no_end,$obligatoire,$obj_DoFormation,$obj_DoEtape, "$chemin_fo/scenario/templates/tpl",array($target_component => 'scenario_page.tpl'));
			
				break;
			
			case TYPE_ETAPE_SCENARIO_DYNAMIQUE:
				include("$chemin_fo/scenario_dynamique/includes.php");
				$etape_page= new guiFoScenarioDynamique($force_no_end,$obligatoire,$obj_DoFormation,$obj_DoEtape, "$chemin_fo/scenario/templates/tpl",array($target_component => 'scenario_page.tpl'));
				break;
			case TYPE_ETAPE_RESSOURCE:
				include("$chemin_fo/etape_ressource/includes.php");
				
				$etape_page = new guiFoEtapeRessource($obj_DoEtape,$obj_DoFormation,"$chemin_fo/etape/templates/tpl",array($target_component => 'gui_fo_do_etape.tpl'));
				break;		
			
			case TYPE_ETAPE_CHAT:
				include("$chemin_fo/etape_chat/includes.php");
				$etape_page = new guiFoEtapeChat("$chemin_fo/etape/templates/tpl",array($target_component=>'gui_fo_do_etape.tpl'));
				break;
			
			case TYPE_ETAPE_FORUM:
				include("$chemin_fo/etape_forum/incFoEtapeForum.php");
				break;
		
			default:
				die("Erreur EtapePageFactory: Le type '$type' n'a pas de scripts d'execution associ.");	
		}	
		
		return $etape_page;	
	}
}
?>