<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit une etape.
 * 
 * @package module
 */ 
class ModulePageCorrectionEtape extends PageComponent{
	/**
	 * Constructeur
	 * 
	 * @param boolean $force_no_end Force � ne pas finir l'�tape.
	 * @param boolean $obligatoire Oblige � reussir l'etape pour passer � l'�tape suivante.
	 * @param object[] $obj_DoFormation Objet contenant toutes les informations de la formation.
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une �tape.
	 * @param object[] $etape_page_factory Objet contenant les informations pour ceer une etape.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
 	 //a renomer en etape page
	function ModulePageCorrectionEtape($block_target,$obj_CorrectionEtape,$module_root=null,$templates=null){
		global $chemin_fo;
		parent::PageComponent($module_root,$templates);
		
		$obj_DoEtape=$obj_CorrectionEtape->getDoEtape();
		$type=$obj_DoEtape->getType();
		$type_court=get_etape_type_formate($type,1); 
		
		$debut= new guiFoEtapeCorrectionDebut('debut_module',$obj_CorrectionEtape,$chemin_fo."/etape/templates/tpl",array('debut_module' => 'gui_fo_etape_correction_page_debut.tpl'));
		$this->setComponent('debut_module', $debut);
		
		$contenu=guiFoEtapeCorrectionFactory::createGuiFoEtapeCorrection('contenu_module',$obj_CorrectionEtape,$chemin_fo."/etape/templates/tpl");//new EtapeCorrectionPageContenu('page_contenu',$obj_DoFormation,$obj_CorrectionEtape,$chemin_fo."/etape/templates/tpl",array('page_contenu' => 'gui_fo_etape_correction_page_contenu.tpl'));
		$this->setComponent('contenu_module', $contenu);
		
		$type_court=(string)get_etape_type_formate($obj_DoEtape->getType(),1);
		
		if($type_court==TYPE_ETAPE_LISTE){
			$fin=new guiFoEtapeCorrectionFinListe('fin_module',$obj_CorrectionEtape,$chemin_fo."/etape/templates/tpl",array('fin_module' => 'gui_fo_etape_correction_page_fin_liste.tpl'));
			$this->setComponent('fin_module', $fin);
		}
		else{
			$fin=new guiFoEtapeCorrectionFin('fin_module',$obj_CorrectionEtape,$chemin_fo."/etape/templates/tpl",array('fin_module' => 'gui_fo_etape_correction_page_fin.tpl'));
			$this->setComponent('fin_module', $fin);
		}
	}
}
?>