<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class permettant l'affichage des fleches de navigations
 */
class NavigateurEtapes extends PageComponent{
	/**
	 * Affiche les fleches de navigations
	 * 
	 * @param boolean $force_no_end Force  ne pas finir l'tape
	 * @param boolean $obligatoire Oblige  reussir l'etape pour passer  l'tape suivante.
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une tape.
	 * @param object[] $obj_DoFormation Objet contenant toutes les informations de la formation.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function NavigateurEtapes($force_no_end,$obligatoire, $obj_DoEtape,$obj_DoFormation,$module_root=null,$templates=null){
		global $MSG_1024,$MSG_1025;
		parent::PageComponent($module_root,$templates);

		//Rcupration des donnes necessaire pour la requete et autre.
		
		$obj_etape= &$obj_DoEtape->getEtape();
		$parcours=$obj_DoEtape->getParcours();
		$formation=$obj_DoEtape->getFormation();
		$individu=$obj_DoEtape->getIndividu();
		$req =get_formation_etape_individu_encadrants($formation,$individu,$parcours,$obj_etape);
		
		$doEtapeFactory = $obj_DoFormation->getDoEtapeFactory();


		//Rcuperation de l'etape prcedente.
		//Formatage du niveau du type prcedent.
		//Creation de l'objet d'avancement pour l'tape prcedent. 
		//Serialisation du lien de l'etape prcedent.
		$row_precedent=pg_fetch_row($req,0);
		if(!empty($row_precedent[0])&&$row_precedent[4]!=TYPE_ETAPE_TITRE){
//			print_rr($row_precedent);
			$type_formate_precedent = get_etape_type_formate($row_precedent[4],1);
			$obj_Doetape_precedent=$doEtapeFactory->createDoEtape($row_precedent[6],$row_precedent[0],$type_formate_precedent);
			$lien_precedent="../parcours/parcours_action.php?force_no_end=$force_no_end&action_target=../etape/etape.php&sz_obj_doetape=".exportObjet($obj_DoEtape)."&action_params=".urlencode("?sz_obj_doetape=".exportObjet($obj_Doetape_precedent));
		}else{
			$lien_precedent="../parcours/parcours_action.php?force_no_end=$force_no_end&action_target=../parcours/parcours.php&sz_obj_doetape=".exportObjet($obj_DoEtape);			
		}


		
		//Rcuperation de l'etape suivante.
		//Formatage du niveau du type suivant.
		//Creation de l'objet d'avancement pour l'tape suivante. 
		//Serialisation du lien de l'etape suivante.
		$row_suivant=pg_fetch_row($req,1);
//		print_rr($row_suivant);
		if(!empty($row_suivant[4])){
			$type_formate_suivant = get_etape_type_formate($row_suivant[4],1);
			$obj_Doetape_suivant=$doEtapeFactory->createDoEtape($row_suivant[6],$row_suivant[0],$type_formate_suivant);
			$lien_suivant="../parcours/parcours_action.php?force_no_end=$force_no_end&action_target=../etape/etape.php&sz_obj_doetape=".exportObjet($obj_DoEtape)."&action_params=".urlencode("?sz_obj_doetape=".exportObjet($obj_Doetape_suivant));
		}else{
			$lien_suivant="../parcours/parcours_action.php?force_no_end=$force_no_end&action_target=../parcours/parcours.php&sz_obj_doetape=".exportObjet($obj_DoEtape);
		}	


		$val ['ETAPE_NAVIGATION_MOINS']="etape_navigation_moins";
		$val ['NAVIGATION_ETAPE_MOINS_URL']="$lien_precedent";
		$val ['NAVIGATION_ETAPE_MOINS_TITLE']=$MSG_1025;
		
		$val ['ETAPE_NAVIGATION_PLUS']="etape_navigation_plus";
		$val ['NAVIGATION_ETAPE_PLUS_URL']="$lien_suivant";
		$val ['NAVIGATION_ETAPE_PLUS_TITLE']=$MSG_1024;
		parent::set_var($val);
	}
}
?>