<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class permettant la creation d'une etape selon son type
 * 
 * @package Etape
 */
class guiFoEtapeCorrectionFactory{
	
	/**
	 * Cre et retourne une EtapePage.
	 * Note: Cette mthode construit une EtapePage en fonction du type d'une Etape, la stocke dans une variable '$etape_page' et la retourne.
	 * correction_exotlc
	 * @param $target_component Variable du tpl pre ou sont stocks les lments pour l'affichage
	 * @param $type_court Variable ou est stock le type format.
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une tape.
	 * @param object[] $obj_DoFormation Objet contenant toutes les informations de la formation.
	 * @param boolean $obligatoire Indique si l'tape est obligatoire ou non.
	 * @param boolean $force_no_end Force  ne pas finir l'tape.
	 * 
	 * @return PageComponent L'EtapePage.
	 */
	function createGuiFoEtapeCorrection($target_component, $obj_DoEtapeCorrection,$module_root){
		global $chemin_fo,$root;	
		
		$tmp_obj_DoEtape=$obj_DoEtapeCorrection->getDoEtape();
		
		$type=$tmp_obj_DoEtape->getType();
		$type_court=(string)get_etape_type_formate($type,1);
		//echo "type=$type_court<br>";
		switch($type_court){
			
			case TYPE_ETAPE_SCORM:
				include("$chemin_fo/scorm/correction_scorm.php");
				break;
			case TYPE_ETAPE_LISTE:
				$type_liste=get_etape_type_formate($type,2); 
				
				switch($type_liste){
					case TYPE_ETAPE_LISTE.'_'.TYPE_LISTE_SERIE:
						
						include("$chemin_fo/serie/includes.php");
						$etape_correction= new guiFoSerieCorrection($target_component,$obj_DoEtapeCorrection,"$chemin_fo/serie/templates/tpl",array($target_component => 'gui_fo_serie_correction.tpl'));
					break;
					
					case TYPE_ETAPE_LISTE.'_'.TYPE_LISTE_TEST:
						include("$chemin_fo/test/correction_test.php");
						break;
					default:
						die("guiFoEtapeCorrectionFactory::createGuiFoEtapeCorrection($target_component, $obj_DoEtapeCorrection,$module_root): Le type de Liste '$type_liste' n'a pas de scripts de correction associ.");						
				}
				break;
			case TYPE_ETAPE_EXOTLC:
				global $chemin_bo;
				include("$chemin_fo/exotlc/includes.php");
				$etape_correction=new guiFoExotlcCorrection($target_component,$obj_DoEtapeCorrection,"$chemin_fo/exotlc/templates/tpl",array($target_component => 'gui_fo_exotlc_correction.tpl'));
				break;
			default:
				die("guiFoEtapeCorrectionFactory::createGuiFoEtapeCorrection($target_component, $obj_DoEtapeCorrection,$module_root): Le type '$type_court' n'a pas de scripts de correction associ.");		
		}	
		return $etape_correction;	
	}
}
?>