<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit une etape.
 * 
 * @package module
 */ 
class guiFoEtapeCorrectionFinListe extends PageComponent{
	/**
	 * Constructeur
	 * 
	 * @param boolean $force_no_end Force  ne pas finir l'tape.
	 * @param boolean $obligatoire Oblige  reussir l'etape pour passer  l'tape suivante.
	 * @param object[] $obj_DoFormation Objet contenant toutes les informations de la formation.
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une tape.
	 * @param object[] $etape_page_factory Objet contenant les informations pour ceer une etape.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function guiFoEtapeCorrectionFinListe($block_target,$obj_CorrectionEtape,$module_root=null,$templates=null){
		parent::PageComponent($module_root,$templates);
		//print_rr($obj_CorrectionEtape);
		//$nb=$obj_CorrectionEtape->getCurrentEvaluationCorrection(1);
		//echo "nb=$nb<br>";
		if(is_object($obj_CorrectionEtape->getCurrentEvaluationCorrection(1))){
			$val['ETAPE_CORRECTION_PAGE_FIN_URL']="../liste/test_do_liste_correction.php?sz_obj_correction_etape=".exportObject($obj_CorrectionEtape);
			$val['ETAPE_CORRECTION_PAGE_FIN_URL_LIBELLE']=MSG_2673;
		}
		else{
			$obj_DoEtape=$obj_CorrectionEtape->getDoEtape();
			$val['ETAPE_CORRECTION_PAGE_FIN_URL']="../parcours/parcours_action.php?action_target=./parcours.php&action_params=&sz_obj_doetape=".exportObject($obj_DoEtape);
			$val['ETAPE_CORRECTION_PAGE_FIN_URL_LIBELLE']="Retour au parcours";	
		}
		$this->set_var($val);
		
	}
}
?>