<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @param DoEtape $sz_obj_doetape Objet d'avancement de l'tape
 * 
 * @package etape_ressource
 */
//----------------------------------------------------------
//					INCLUSIONS
//----------------------------------------------------------
//EN TETE DE LA PAGE
$dbpath="../..";
include("$dbpath/en_tete.php");
include("../en_tete_front.php");
include ("$chemin_fo/etape_ressource/includes.php");
//-----------------------------------------------------------
//					Initialisation objet DoEtape
//-----------------------------------------------------------
//on recupere l'objet d'avancement de l'URL (Etape libre)
if(!empty($sz_obj_doetape)){
	$obj_DoEtape_URL=importObjet($sz_obj_doetape);
	$obj_DoEtape=&$obj_DoEtape_URL;
//	echo "URL";
}

//on recupere l'objet d'avancement de la session (Etape courante)
if(!empty($obj_DoFormation)){
	$obj_DoEtape_SESSION=&$obj_DoFormation->getCurrentDoEtape();
	if(is_object($obj_DoEtape_SESSION)){
		if($obj_DoEtape_URL){
			if($obj_DoEtape_SESSION->compareTo($obj_DoEtape_URL)){
				$obj_DoEtape=&$obj_DoEtape_SESSION;
			}
		}
		else{
			$obj_DoEtape=&$obj_DoEtape_SESSION;
		}
	}
	else{
		 $obj_DoEtape=&$obj_DoEtape_URL;
	}
}

//print_rr($obj_DoFormation);
//traitement de l'objet DoEtape
if(is_object($obj_DoEtape)){
	//debut de l'tape	
	if(!$obj_DoEtape->isBegin()&&!$obj_DoEtape->isEnd())$obj_DoEtape->beginCurrentEtape();
	
	//recup de l'objet tape
	$obj_DoEtape->performCurrentEtape(new EtapeFactory());
	$obj_etape=& $obj_DoEtape->getObjEtape();
	$parcours=$obj_DoEtape->getParcours();
	$formation=$obj_DoEtape->getFormation();
	$individu=$obj_DoEtape->getIndividu();
	if(is_object($obj_etape)){
	
		$id=$obj_etape->getId();
		$type=$obj_etape->getType();
		if(empty($id)||empty($type)){
			die("Erreur etape.php: valeurs manquantes:\$id=$id<br>  \$type=$type<br>");	
		}
		
	}else{
		die("Erreur etape.php: l'tape n'a pu tre cre.");
	}
}else{
	die("Erreur etape.php: les parametres requis par la page sont incomplets. ");
}


//-----------------------------------------------------------
//			AFFICHAGE ETAPE_RESSOURCE
//-----------------------------------------------------------

$page_builder->setModuleRoot("$chemin_fo/module/templates/tpl");
	
//les styles
$liste_style_files=list_file($page_builder->getStylePath());
foreach($liste_style_files as $s=>$style_file){
	foreach($style_file as $style_file_path=>$style_file_name){
		$style_files[$style_file_path][]=$style_file_name;	
	}
}
messageDebugR("Fichier CSS chargs:",$style_files);	
	
//les fichiers javascripts
$javascript_files=array();
messageDebugR("Fichier javascript chargs:",$javascript_files);	

//le javascript interne
//$javascript_internal_code=get_individu_formation_javascript($_SESSION["auth"]->getUserId());
messageDebug("Code javascript charg:<br>$javascript_internal_code");	

$libelle_titre = "Etape Ressource";
$numetape=0;



//les lments pour la page
$page_debut = new ModulePageDebut($libelle_titre,$force_no_end,$obj_DoEtape,$formation,$page_builder->getModuleRoot(),array('page_debut' => 'module_page_debut.tpl'));
$page_contenu=new guiFoSectionRessources($numetape,$obj_DoEtape,$formation,$espace, $section,$ressource="",$page_builder->getModuleRoot(),array('page_contenu' => 'module_page_contenu.tpl'));
$page_fin = new ModulePageFin($page_builder->getModuleRoot(),array('page_fin' => 'module_page_fin.tpl'));

//la page spcifique	
$page=new ModulePage($page_builder, array('page_dev' => 'module_page.tpl'),$style_files,$javascript_files,$javascript_internal_code);

//affectation des lments
$page->setComponent('page_debut', $page_debut);
$page->setComponent('page_contenu', $page_contenu);
$page->setComponent('page_fin',$page_fin);

//on parse
$page->parse();
//on affiche
$page->p();


include("../pied_page.php");
exit();





























//-----------------------------------------------------------
//					Inclusions
//-----------------------------------------------------------
//$dbpath="..";
////$javascriptFILE = "./javascript_serie.php";
////include("../lib/identification.php3");
//include("$chemin_bo/lib/lib_ressource.php");
//
//$nbparligne=4;
//
//
//// debug
///*
//echo "<pre>";
//print_r($obj_etape);
//echo "</pre>";
//*/
//
//// prparation des donnes
//$espace=$obj_etape->getEspace();
//if($espace){
//	$section=$obj_etape->getSection();
//	if($section){
//		$ressource=$obj_etape->getRessource();
//		if($ressource){
//			$nbressource=1;
//			$fichier_num[1]=$obj_etape->getFichier();
//			$restype=get_fichier($obj_etape->getFichier());
//			$typefic[1]=pg_fetch_result($restype,0,2);
//			$espace_num[1]=$espace;
//			$resespace=get_espace($espace);
//			$espace_titre[1]=pg_fetch_result($resespace,0,1);
//			$section_num[1]=$section;
//			$ressection=get_section($section);
//			$section_titre[1]=pg_fetch_result($ressection,0,1);
//			$section_icone[1]=pg_fetch_result($ressection,0,2);
//			$libelle[1]=$obj_etape->getLibelle();
//			/*
//			$type[$i]=$row[8];
//			$datedeb[$i] = ereg_replace('^([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})$', '\3/\2/\1', $row[10]);
//			$datefin[$i]  = ereg_replace('^([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})$', '\3/\2/\1', $row[11]);
//			$nouveau[$i]=$row[12]; // NOTE : if faut determiner si la ressouce est encore nouvelle (A SUIVRE ...)
//			$section_icone[$i]=$row[13];
//			*/
//			
//		}
//		else{
//			// ici il faut recuprer les ressource de la formation pour l'epace et la section
//			$resressource=get_formation_espace_section_ressources($formation,$espace,$section);
//		}
//	}
//	else{
//		// ici il faut recuperer les ressource de la formation pour un espace
//		$resressource=get_formation_espace_ressources($formation,$espace);
//	}
//}
//else{
//	// redirection vers les ressouces de la formation
//	header("location:../ressource/index.php3");
//	exit();
//}
//// preparation des donnes suite
//if($resressource){
//$nbressource=pg_num_rows($resressource);
////echo "nb=$nbressource<br>";
//	// Cration du tableau d'information
//	for($i=1;$i<=$nbressource;$i++){
//		$row=pg_fetch_row($resressource,$i-1);
//		/*
//	   	echo "<pre>";
//		print_r($row);
//		echo "</pre>";
//		*/
//	   	
//		$espace_num[$i]=$row[2];
//		$espace_titre[$i]=$row[3];
//		$section_num[$i]=$row[4];
//		$section_titre[$i]=$row[5];
//		$nouveau[$i]=$row[12]; // NOTE : if faut determiner si la ressouce est encore nouvelle (A SUIVRE ...)
//		$section_icone[$i]=$row[13];
//		if($section){
//			$fichier_num[$i]=$row[1];
//			$libelle[$i]=$row[6];
//			$typefic[$i]=$row[8];
//			$datedeb[$i] = ereg_replace('^([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})$', '\3/\2/\1', $row[10]);
//			$datefin[$i]  = ereg_replace('^([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})$', '\3/\2/\1', $row[11]);
//		}
//	}
//			
//}
//
//// affichage des ressources
//print("
//<table class=\"tableau_contenu\">
//<tr>
//<td colspan=\"6\">
//<table class=\"tableau_contenu_ressources\">
//");
//if($section){
//	include('../ressource/affichage_ressource.php');
//}
//else{
//	include('../ressource/affichage_espace.php');
//}

?>