<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'affichage d'une etape ressource
 * 
 * @package Ressource
 */
class guiFoEtapeRessource extends PageComponent{
	
	/**
	 * @var object Objet graphique contenant le texte et le moteur au debut de la page ressource
	 */
	var $debut;
	
	/**
	 * @var object Objet graphique contenant les espaces sections
	 */
	var $contenu_ressource;
	
	/**
	 * @var object Objet graphique contenant l'icone et le libelle d'une section
	 */
	var $contenu_sections_image;
	
	/**
	 * @var object Objet graphique contenant le descriptif de la ou des ressources
	 */
	var $contenu_ressource_fin;
	/**
	 * Consructeur
	 * 
	 * @param object[] $obj_DoEtape Objet contenant les informations d'une etape
	 * @param object[] $obj_DoFormation Objet contenant les informations d'une formation
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */	
	function guiFoEtapeRessource($obj_DoEtape,$obj_DoFormation,$module_root=null,$templates=null){
		global $chemin_fo;
		
		parent::PageComponent($module_root,$templates);
		
		
		$etape_debut=new NavigateurEtapes(false,false,$obj_DoEtape,$obj_DoFormation,"$chemin_fo/etape/templates/tpl",array('etape_debut' => 'navigateur_etape.tpl'));
		$etape_fin=new NavigateurEtapes(false,false,$obj_DoEtape,$obj_DoFormation,"$chemin_fo/etape/templates/tpl",array('etape_fin' => 'navigateur_etape.tpl'));
		$this->setComponent('etape_debut', $etape_debut);
		$this->setComponent('etape_fin', $etape_fin);
		
		//On recupere les Objet respectif
		$formation=$obj_DoFormation->getFormation();
		$obj_Etape = $obj_DoEtape->getEtapeRessource();
		//print_rr($obj_Etape);
		//Attribution des valeurs
		$id_etape = $obj_Etape->getId();
		$obj_espace=$obj_Etape->getObjEspace();
		$obj_section=$obj_Etape->getObjSection();
		$id_fichier=$obj_Etape->getFichier();
		
//		print_rr($obj_Etape);
		
		//Affichage de tous les espaces de la formation
		if(empty($obj_espace)){
			
			$this->contenu_ressource = new guiFoEspaces($obj_DoEtape,'etape_contenu','',$formation,"$chemin_fo/ressource/templates/tpl",array('etape_contenu'=>'gui_fo_espaces.tpl'));
		}
		//Affichage d'un espace
		else{
		
			//Affichage de toutes les sections de l'espace
			if(empty($obj_section)){
				
				//Affichage de toutes les sections de la formation et de son espace 
				$this->contenu_ressource = new guiFoEspaces($obj_DoEtape,'etape_contenu',$obj_espace->getId(),$formation,"$chemin_fo/ressource/templates/tpl",array('etape_contenu'=>'gui_fo_espaces.tpl'));			
			}
			//Affichage d'une section de l'espace
			else{

				//affichage de toutes les ressources de l'espace et de la section
				if(empty($id_fichier)){
					$this->contenu_ressource= new guiFoRessources('etape_contenu',new guiFoRessourceFactory(),$obj_espace->getId(), $obj_section->getId(),$id_fichier,"$chemin_fo/ressource/templates/tpl",array('etape_contenu'=>'gui_fo_ressources.tpl'));
				
				}
				//affichage d'une ressource de l'espace et de la section
				else{
					$this->contenu_ressource = new guiFoEtapeRessourceRessource($obj_Etape,"$chemin_fo/etape_ressource/templates/tpl",array('etape_contenu' => 'gui_fo_etape_ressource_ressource.tpl'));
				}
			}	
		}
		
		$this->setComponent('etape_contenu', $this->contenu_ressource);
		
	}
}
?>