<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class construit l'affichage de la ressource adequat  l'identifiant du type selectionn
 *
 *@package ressource
 **/
class guiFoEtapeRessourceFactory {
	/**
	 * Cre et retourne une Ressource.
	 * Note:construit une Ressource selon le type selectionn et stocke dans une varible $ressource et la retourne
	 * 
	 * @param  string $target_component  Le nom de la variable qui contiendra la boucle dans le tpl.
	 * @param  string $module_root Le chemin du dossier contenant les tpl requis
	 * @param  integer $type L'identifiant de la constante utilis
	 * @param  integer $num_fichier L'identifiant du fichier
	 * @param  string $libelle_ressource Le libelle de la ressource
	 * @param  string $datedeb La date de debut de la ressource 
	 * @param  string $datefin La date de fin de la ressource 
	 * @param  integer $num_ressource L'identifiant de la ressource
	 * @param  integer $numero_espace L'identifiant de l'espace
	 * @param  integer $numero_section L'identifiant de la section
	 * @param  integer $formation L'identifiant de la formation
	 * 
	 * @return PageComponent $ressource
	 */
	function createGuiFoEtapeRessource($target_component,$module_root,$obj_etape_ressource){
		global $chemin_fo;
		//echo "coucou<br>";
		//print_rr($obj_etape_ressource);
		switch($obj_etape_ressource->getFichierType()){
			case TYPE_FICHIER_RESSOURCE_TEXTE:
				$ressource=new guiFoEtapeRessourceTexte($obj_etape_ressource,$module_root,array($target_component => 'gui_fo_etape_ressource_texte.tpl'));
				break;
			case TYPE_FICHIER_RESSOURCE:
				$ressource=new guiFoEtapeRessourceFichier($obj_etape_ressource,$module_root,array($target_component => 'gui_fo_etape_ressource_fichier.tpl'));
				break;
			case TYPE_FICHIER_SCENARIO:
				$ressource=new guiFoEtapeRessourceScenario($obj_etape_ressource,$module_root,array($target_component => 'gui_fo_etape_ressource_scenario.tpl'));
				break;
			default:
				die("Erreur createGuiFoEtapeRessource: Le type '".$obj_etape_ressource->getFichierType()."' n'a d'objet associ.");	
		}
		
		return $ressource;	
	}
}
?>