<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche la ressource fichier.
 * 
 * @package ressource
 */
class guiFoEtapeRessourceFichier extends PageComponent{
	/**
	 * Affichage de ressource fichier
	 * 
	 * @param  integer $num_fichier L'identifiant du fichier
	 * @param  string $libelle_ressource Le libelle de la ressource
	 * @param  string $datedeb La date de debut de la ressource 
	 * @param  string $datefin La date de fin de la ressource 
	 * @param  integer $num_ressource L'identifiant de la ressource
	 * @param  integer $numero_espace L'identifiant de l'espace
	 * @param  integer $numero_section L'identifiant de la section
	 * @param  integer $formation L'identifiant de la formation
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoEtapeRessourceFichier($obj_etape_ressource,$module_root=null,$templates=null){
		
		global $chemin_fo,$pos;	
		
		parent::PageComponent($module_root,$templates);
			
			$fichier_theme = get_categorie_element_themes(TYPE_CATEGORIE_RESSOURCE, $obj_etape_ressource->getFichier()) ;
			$row = pg_fetch_row($fichier_theme);
			$num_theme = $row[0];
			
			$chemin_fichier=get_fo_fichier_chemin_relatif($obj_etape_ressource->getFichier(),$num_theme,TYPE_CATEGORIE_RESSOURCE);
			
			$resfic=get_fichier($obj_etape_ressource->getFichier());
			$nomfic=pg_fetch_result($resfic,0,1);
			
			$extension = $nomfic;
			$extension = substr($nomfic, $pos, strlen($nomfic));
			
			
			$val['LIEN_URL']= "$path./..$chemin_fichier";
			// gestion ams
			
			//$val['LIBELLE_RESSOURCE']=$obj_etape_ressource->getLibelle();
			$val['LIBELLE_RESSOURCE']=get_fo_libelle($obj_etape_ressource->getLibelle());
			$val['RESSOURCE_TEXTE_DESCRIPTION']=" ($extension - " . sprintf("%01.2f", (filesize($chemin_fo."/".$chemin_fichier) / 1024)) . " Ko)";
		 
			parent::set_var($val);
	}
}
?>