<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'affichage d'une etape ressource
 * 
 * @package Ressource
 */
class guiFoEtapeRessourceRessource extends PageComponent{
	
	/**
	 * Consructeur
	 * 
	 * @param object[] $obj_DoEtape Objet contenant les informations d'une etape
	 * @param object[] $obj_DoFormation Objet contenant les informations d'une formation
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */	
	function guiFoEtapeRessourceRessource($obj_Etape,$module_root=null,$templates=null){
		global $chemin_fo;
		
		parent::PageComponent($module_root,$templates);
		
		//On recupere les Objet 
		$obj_espace=$obj_Etape->getObjEspace();
		$obj_section=$obj_Etape->getObjSection();
		$id_fichier=$obj_Etape->getFichier();
		
		
		
					
		//Affichage de l'espace
		$ressource_espace = new guiFoEspace($obj_espace,"$chemin_fo/ressource/templates/tpl",array('ressource_espace' => 'gui_fo_espace.tpl'));
		//affichage de la section;
		$ressource_section =new guiFoSectionsImage ($obj_section->getIcone(),$obj_section->getLibelle(),"$chemin_fo/ressource/templates/tpl",array('ressource_section'=>'gui_fo_sections_image.tpl'));					
	
		//affichage de l'espace,section et de la ressource
		$guiFoRessourceFactory = new guiFoEtapeRessourceFactory();
		$ressource_ressource = $guiFoRessourceFactory->createguiFoEtapeRessource('ressource_ressource',"$chemin_fo/etape_ressource/templates/tpl",$obj_Etape);

		$this->setComponent('ressource_espace', $ressource_espace);
		$this->setComponent('ressource_section', $ressource_section);
		$this->setComponent('ressource_ressource', $ressource_ressource);
	}
}
?>