<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche la ressource scenario.
 * 
 * @package ressource
 */
class guiFoEtapeRessourceScenario extends guiFoScenarioContenu{
	/**
	 * Affichage de ressource scenario
	 * 
	 * @param  integer $num_fichier L'identifiant du fichier
	 * @param  string $libelle_ressource Le libelle de la ressource
	 * @param  string $datedeb La date de debut de la ressource 
	 * @param  string $datefin La date de fin de la ressource 
	 * @param  integer $num_ressource L'identifiant de la ressource
	 * @param  integer $numero_espace L'identifiant de l'espace
	 * @param  integer $numero_section L'identifiant de la section
	 * @param  integer $formation L'identifiant de la formation
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoEtapeRessourceScenario($obj_etape_ressource,$module_root=null,$templates=null){
		
		global $chemin_fo,$pos,$MSG_2539,$MSG_2540;	
		
		parent::guiFoScenarioContenu($obj_etape_ressource,$module_root,$templates);
			//print_rr($obj_etape_ressource);
				
			$fichier_theme = get_categorie_element_themes(1, $obj_etape_ressource->getFichier()) ;
//			print_rr($obj_etape_ressource);
			$row = pg_fetch_row($fichier_theme);
			$num_theme = $row[0];
			$num_theme=14;
			$chemin_fichier=get_fichier_chemin_relatif($obj_etape_ressource->getFichier(),$num_theme,1);
			$chemin_fichier=get_fo_fichier_chemin_relatif($obj_etape_ressource->getFichier(),$num_theme,1);
			$resfic=get_fichier($obj_etape_ressource->getId());
			$nomfic=pg_fetch_result($resfic,0,1);
			$extension = $nomfic;
			$extension = substr($nomfic, $pos, strlen($nomfic));
			
			
			$val['LIBELLE_RESSOURCE']=get_fo_libelle($obj_etape_ressource->getLibelle());
		 	//$val['RESSOURCE_ID']=$obj_etape_ressource->getId();
		 	$val['RESSOURCE_ID']=$obj_etape_ressource->getFichier();
		 	$val['LIEN_URL']= "$path./..$chemin_fichier";
			$this->set_var($val);
	}
}
?>