<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Script d'affichage de la correction d'un Exotlc.
 * Il gre  l'affichage pour la correction.
 * 
 * @param object DoExotlc L'objet d'avancement pour l'affichage de l'Exotlc.
 * @param object ExotlcCorrection L'objet de correction de l'Exotlc.
 * 
 * @package exotlc
 */


//-----------------------------------------------------------
//					Inclusions
//-----------------------------------------------------------
$dbpath="..";
$javascriptFILE = "./javascript_serie.php";
//include("../lib/identification.php3");
include("$chemin_bo/lib/lib_exotlc.php");

//-----------------------------------------------------------
//					Initialisation
//----------------------------------------------------------
// recup identifiant resultat
$id_resultat=$obj_CorrectionEtape->getResultat();
//echo "id_res=$id_resultat<br>";

// recup etape
$etape=$obj_CorrectionEtape->getId();
//echo "etape=$etape<br>";
$resetape=get_etape($etape);
$libelle=pg_fetch_result($resetape,0,1);
//echo "lib=$libelle<br>";

// type
$type_exotlc=get_exotlc_type($etape);
//echo "type=$type<br>";




// obj_doetape
$obj_DoEtape=$obj_CorrectionEtape->getDoEtape();
//print_rr($obj_DoEtape);


if($type_exotlc==TYPE_EXOTLC_PLATEFORME){
	
	$fichier_rendu= $obj_CorrectionEtape->getFichierRendu();
	//echo "fichier_rendu=$fichier_rendu<br>";
}

// date correction
$date_correction=sql_timestamp_to_string($obj_CorrectionEtape->date_correction);
//echo "date_correction=$date_correction<br>";
$date=$obj_DoEtape->getDateCorrectionFormatee();     
//echo "date=$date<br>";



// recup des sous criteres 
$verifdejapresent=get_resultat_exotlc_sous_criteres($id_resultat);
$numcols = pg_num_rows($verifdejapresent);
//echo "numcols=$numcols<br>";
// recup des rubriques pour ce resultat
$resrub=get_resultat_exotlc_criteres($id_resultat);
$numrub = pg_num_rows($resrub);
//echo "numrub=$numrub<br>";
// stockage des criteres
$tabrub = array();
for ($i = 0; $i < $numrub; $i ++) {
	$rowrub = pg_fetch_row($resrub, $i);
	if (!in_array("$rowrub[1]", $tabrub)) {
		$tabrub[] = $rowrub[1];
		messageDebug("Ajoute ".$rowrub[1]." aux rubriques  traiter.");
	}
}
// debug
//print_rr($tabrub);
//print_rr($obj_CorrectionEtape);
//-----------------------------------------------------------
//					AFFICHAGE
//----------------------------------------------------------

print("
<table class=\"tableau_contenu\">
<tr bgcolor=\"#cccccc>
<td colspan=2>
");

// premiere ligne du tableaux :  Affichage d' "exercice  telecharger"
print("
<table class=\"tableau_titre_etape\" width=\"100%\">

<tr bgcolor=\"#333399\">
<td class=\"barre_titre_etape\" align=left colspan=2>
<span class=\"texte_tableau_titre_etape\">$MSG_1173&nbsp;&nbsp;:</span>&nbsp;&nbsp;
<span class=\"texte_tableau_titre_etape\"><i>$libelle</i></span></td>
</tr>
<tr bgcolor=\"#ffedb7\">
<td colspan=2>

");
// affichage date de rendu si exotlc plateforme
if($fichier_rendu){
	//calcul des chemins
	$chemin_exo=$chemin_fo.UPLOAD_EXOTLC_DIR."".$obj_DoEtape->getFormation()."/";
	//echo "chemin_exo=$chemin_exo<br>";
    $url_exo="http://".$serverfront.UPLOAD_EXOTLC_DIR."".$obj_DoEtape->getFormation()."/";
    $fic_nom=get_fichier_name(get_exotlc_fichier_nom($etape,$fichier_rendu,$obj_DoEtape->getParcours(),$obj_DoEtape->getIndividu() ));
	// recup de la date d'envoi 
	
	$date=get_fichier_date_modification($chemin_exo.get_exotlc_fichier_nom($etape,$fichier_rendu,$obj_DoEtape->getParcours(),$obj_DoEtape->getIndividu()));
	print("
	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><ul>$MSG_1354 <b>$date[0]</b> $MSG_1355 <b>$date[1]</b>
	<br>
	<!--
    $lien<IMG border=0 src=\"../data/images/loupetr.gif\" align=\"absmiddle\" ALT=\"voir votre exercice\" width=49 height=28></a>
	<i><small> (".$obj_etape->getFichierRendu().")</small></i>
	-->
	");
}
// affichage date correction
print("
<br>$MSG_1724 : <b>$date_correction</b>
</td></tr>
");
 print("
 <TR>
 <td colspan=2>
 ");
// boucle sur les criteres

for($c=0;$c<sizeof($tabrub);$c++){
	$j=1;
	$rub = $tabrub[$c];
	
	// recup commentaire critere et note
		$rescomment=get_resultat_exotlc_critere($id_resultat,$rub);
		$rowcomment = pg_fetch_row($rescomment, 0);
		//print_r($rowcomment);
		$comment = htmlentities($rowcomment[4]);
	
	//echo "rub=$rub<br>";
	//On compte le nombre de sous rubriques pour une rubrique courante
	/*
	$rescols = pg_query("select distinct gesttlc_srub from GESTEXOTLC where
			gesttlc_rub='$rub'and gesttlc_exo='$exo' and gesttlc_user='$numuser' and num_cal='$num_cal' ;");
	*/
	$rescols=get_resultat_exotlc_critere_sous_criteres($id_resultat,$rub);		
	$nbcols = pg_num_rows($rescols);
    //echo "nbcols=$nbcols<br>";
	$k = $i +1;
	$reslib=get_critere($rub);
	$lib=pg_fetch_result($reslib,0,1);
	print("
	<center><table width=\"100%\">
	<tr bgcolor=\"#ffcc33\">
	<td colspan=2 align=center><font color=\"#000000\" size=4><b>$lib</b></font></td>
	</tr>
	"); 
	
	
	
	
	if ($nbcols != 0) {
		print("
		<tr bgcolor=\"#ffe493\">
		<td><font color=\"#333399\" size=2><b>$MSG_1164 </b></font></td>
		<td><font color=\"#333399\" size=2><b>$MSG_1174</b></font></td>
		</tr>
		");	
		// boucle sur les sous criteres
		$somme=0;
		$total=0;
		
		
		for($sc=0;$sc<$nbcols;$sc++){
			$rowsc=pg_fetch_row($rescols,$sc);
			$reslib=get_critere($rowsc[2]);
			$lib=pg_fetch_result($reslib,0,1);
			print("
			<tr bgcolor=\"#ffe493\">
			<td><font color=\"#333399\" size=2>$j . $lib</font></td>
			<td><font color=\"#333399\" size=2><b>$rowsc[3]/$rowsc[4]</b></font></td>
			</tr>
			");
			$somme +=$rowsc[3];
			$total +=$rowsc[4];
			$j++;
		}
	
		// recup commentaire critere et note
		$rescomment=get_resultat_exotlc_critere($id_resultat,$rub);
		$rowcomment = pg_fetch_row($rescomment, 0);
		//print_r($rowcomment);
		$comment = htmlentities($rowcomment[4]);
		
		$note_critere=(20*$somme/$total);
		$note_critere=(round($note_critere*100))/100;
	
	} 
	else {
		$resnote=get_resultat_exotlc_critere($id_resultat,$rub);
		$rownote=pg_fetch_row($resnote,0);	
		//print_rr($rownote);
		$note_critere=(20*$rownote[2]/$rownote[3]);
		$note_critere=(round($note_critere*100))/100;	
	
	}
		print("
		<tr bgcolor=\"#fedda7\">
		<td><font color=\"#333399\" size=2><b>$MSG_1175</b><br><i>$comment</i></font></td>
		<td><font color=\"#333399\" size=2><b>$MSG_1174<br>$note_critere/20 </b></font></td>
		</tr>
		");	
	
	
	print("</table>");
}
print "\n</td></TR>";
// commentaire general et note general
$rescomment=get_resultat_exotlc($id_resultat);
$commentgen=pg_fetch_result($rescomment,0,7);
$corrige=pg_fetch_result($rescomment,0,8);
// recup de la note general (sur 20)
$resnotegen=get_resultat_exotlc_moyenne($id_resultat);
$note=pg_fetch_result($resnotegen,0,0);
 $note = sprintf("%01.2f", $note);
 print("
<tr bgcolor=\"#ffcc33\">
<td><font color=\"#333399\" size=3><b>$MSG_788</b><br><i>$commentgen</i></font></td>
<td><font color=\"#333399\" size=3><b>$MSG_783</b><br>$note</b></font></td>
</tr>
 ");


print("
</table>
</td></tr></table>
");

?>