<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @param File $userfile
 * @param DoEtape $sz_obj_doetape
 */
 
//----------------------------------------------------------
//					INCLUSIONS
//----------------------------------------------------------
//EN TETE DE LA PAGE
$dbpath="../..";
include("$dbpath/en_tete.php");
include("../en_tete_front.php");
//require('../lib/identification.php3');
//require("$chemin_bo/lib/lib_front_office.php");
include("$chemin_fo/exotlc/includes.php");
//pg_query("begin");
//$NIVEAU_DEBUG=1;
//print_rr($_POST);
//-----------------------------------------------------------
//					Initialisation objet DoEtape
//-----------------------------------------------------------

//on recupere l'objet d'avancement de l'URL (Etape libre ou dj faite)
if(!empty($_POST['upload_sz_object'])){
	$obj_DoEtape_URL=importObject($_POST['upload_sz_object']);
	$obj_DoEtape=&$obj_DoEtape_URL;
	messageDebugR("Recupration de l'tape de l'URL",$obj_DoEtape);
}
//print_rr($obj_DoEtape);
//on recupere l'objet d'avancement de la session (Etape courante)
$obj_DoEtape_SESSION=&$obj_DoFormation->getCurrentDoEtape();
if(is_object($obj_DoEtape_SESSION)){
	if($obj_DoEtape_URL){
		if($obj_DoEtape_SESSION->compareTo($obj_DoEtape_URL)){
			$obj_DoEtape=&$obj_DoEtape_SESSION;
		}
	}
	else{
		$obj_DoEtape=&$obj_DoEtape_SESSION;
	}
	messageDebugR("Recupration de l'tape de la session",$obj_DoEtape);
}
else{
	 $obj_DoEtape=&$obj_DoEtape_URL;
}
messageDebugR("Etape choisie:",$obj_DoEtape);

$obj_etape=&$obj_DoEtape->getObjEtape();
//-----------------------------------------------------------
//					UPLOAD
//----------------------------------------------------------- 
$err=false;
$type_message=MSG_ERROR;
//print_rr($_FILES);
$userfile_name=$_FILES['exotlc_fichier_rendu_data']['name'];
$userfile_size=$_FILES['exotlc_fichier_rendu_data']['size'];
$userfile=$_FILES['exotlc_fichier_rendu_data']['tmp_name'];
//repertoire de destination des exotlc
$chemin_exo=$chemin_fo.UPLOAD_EXOTLC_DIR;
messageDebug("Repertoire de destination des exotlc:$chemin_exo");
//si le repertoire exotlc n'existe pas au sein du repertoire fichiers_stagiaires, on le cre
if(!is_dir($chemin_exo)){
	mkdir($chemin_exo,0777);
}

//On va ranger les exos dans un repertoire de Reception
//qui prend comme nom le numero de formation
$chemin_exo.=$obj_DoEtape->getFormation()."/";
messageDebug("Repertoire de destination des exotlc pour la formation:$chemin_exo");
//si le repertoire n'existe pas au sein du repertoire reception, on le cre
if(!is_dir($chemin_exo)){
	mkdir($chemin_exo,0777);
}
	
//verif du nom du fichier fourni par le stagiaire
messageDebug("Fichier envoy:$userfile_name");
messageDebug("Fichier attendu:".$obj_etape->getFichierRendu());
if($userfile_name!=$obj_etape->getFichierRendu()){
	$err=true;
	$message=$MSG_1352." : <b>".$obj_etape->getFichierRendu()."</b><br>".$MSG_1353;
}

//vrif de la taille du fichier fourni par le stagiaire
if($userfile_name!=$obj_etape->getFichierRendu()){
	$err=true;
	$message=$MSG_1352." : <b>".$obj_etape->getFichierRendu()."</b><br>".$MSG_1353;
}
if(!$err){
    //On traite le nom du fichiers pour qu'il soit reconnaissable,
    //On lui ajoute donc le numero du stagiaire ainsi que le numro d'exo.
    $tmp_ext=get_fichier_extension($userfile_name);
    $nomfic=$obj_DoEtape->getParcours()."_".$obj_DoEtape->getIndividu()."_".$obj_etape->getId().".".$tmp_ext;
    
	$msg_upload=uploadFichier($userfile, $userfile_name, $userfile_size, $nomfic, $chemin_exo);
    //erreur upload
    if (!empty($msg_upload)){
		$message=$msg_upload;
    }
    else{
		// On stocke les message d'erreur dans une variable pour
		//faire un rollback en cas d'erreur de copie du fichier
		ob_start();
		pg_query("begin");
    	
    	$cur_indiv=$obj_DoEtape->getIndividu();
    	$cur_form=$obj_DoEtape->getFormation();
    	$cur_parc=$obj_DoEtape->getParcours();
    	$cur_exo=$obj_etape->getId();
    	
    	//Insertion en table des donnes de l'exo, ainsi que la date d'envoie du fichier
    	$ins=set_exotlc_fichier_stagiaire($cur_exo,$cur_indiv ,$cur_form,$cur_parc,$userfile_name);
    	$obj_resultat=$obj_DoEtape->getCurrentResultat();
		$obj_resultat->init($ins);
//    	$obj_DoEtape->endCurrentEtape($obj_resultat);
    	
    	//on recupere les messages d'erreur
		$message_erreur = ob_get_contents();
		//on vide les messages stockes
		ob_end_clean();
		//on copie le fichier si pas d'erreur de requete
		if (empty ($message_erreur)&&!empty($ins)) {
			$message= $MSG_1351;
			$type_message=MSG_CONFIRM;
			pg_query("commit");
			//on recupere le resultat courant
			$obj_resultat=&$obj_DoEtape->getCurrentResultat();
			$obj_resultat->init($ins);
//			print_rr($obj_resultat);
			$obj_DoEtape->endCurrentEtape(&$obj_resultat);
			
		}else{
		
			//suppression de l'ancien fichier
			del_exotlc_fichier_stagiaire($cur_exo, $cur_indiv,$cur_form,$cur_parc,$ins);
			$message=$message_erreur;
			pg_query("rollback");
		}
    }
}
AstairsTemplate::setPageMessage($message,$type_message);
//		echo $message;
//$force_no_end=true;
$action_target="affichageUploadExotlc.php";
//$action_params="?message=".urlencode($message);
//include("../parcours_action.php");
header("location:../etape/etape.php?sz_obj_doetape=".exportObject($obj_DoEtape));
include("../pied_page.php");
?>