<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on Apr 9, 2008
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 /**
  * Class qui construit le contenu tpl pour une correction valuation ftb
  * 
  * @author Ladjani said
  * @version 
  * @package ftb
  */
class guiFoModuleEvaluationCorrectionFtb extends PageComponent{
  
  	/**
	 * Constructeur
	 * 
	 * @param object[] objet evaluation
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 */
	 function guiFoModuleEvaluationCorrectionFtb($block_target,$obj_evaluation_correction,$module_root,$templates){
	 	parent::PageComponent($module_root,$templates);
	 	
	 	global $serverfront,$s_langue;
	 	
	 	// NOTE : Depuis la mise en place des AMS, quelques modifications sont ncessaires pour le ftb
	 	// 1 - Le texte de rfrence pour la correction doit tre de la langue ams du champ  rponse
	 	// 2 - La mthode getBlanc() doit s'oprer sur le texte de rfrence
	 	// 3 - 
	 	
		// recup objet evaluation
	 	$this->obj_EvaluationCorrection=$obj_evaluation_correction;
	 	//print_rr($obj_evaluation_correction);
	 	$obj_evaluation=$obj_evaluation_correction->getEvaluation();
	 	
	 	// resultat et n ftb
	 	$resultat=$this->obj_EvaluationCorrection->getResultat();
	 	$num_ftb=$this->obj_EvaluationCorrection->getId();
	 	//echo "resultat=$resultat et ftb=$num_ftb<br>";
	 	
	 	// Les mots saisies et la langue ams de la reponse
	 	$res=get_resultat_serie_ftb($this->obj_EvaluationCorrection->getResultat(),$this->obj_EvaluationCorrection->getId());
	 	if(pg_num_rows($res)==1){
	 	$row=pg_fetch_row($res,0);
	 	//print_rr($row);
	 	$langue_ams=$row[4];
	 	
	 	
	 	
	 	// recup obj_etape_correction
	 	$obj_etape_correction=$this->obj_EvaluationCorrection->getEtapeCorrection();
	 	// l'objet serie
	 	$obj_serie=$obj_etape_correction->getEtape(new EtapeFactory());

	 	// point pour l'evaluation
	 	$point=$obj_serie->getPoints($this->obj_EvaluationCorrection->getId());
	 	$commentaire=$obj_serie->getCommentaire($this->obj_EvaluationCorrection->getId());
	 	
	 	// la note
	 	$note_ftb=get_resultat_serie_ftb_scores($this->obj_EvaluationCorrection->getResultat(),$this->obj_EvaluationCorrection->getId());
	 	}
	 	else
	 		$langue_ams=$s_langue;
	 	
	 	 //on sort les mots  trouver de l'nonc
	    $tab_mots=$this->obj_EvaluationCorrection->obj_Evaluation->getBlancs($langue_ams);
	    //print_rr($tab_mots);
		$nb_tab_mots=count($tab_mots);
	 	
	 	
	 	// placer les mots
	 	
	 	if($obj_evaluation->isVoirMots()){
	 		
	 		$tab_mots=$obj_evaluation->getBlancs($langue_ams);
	 		if(count($tab_mots)>1){
	 			
	 			$component=new guiFoEvaluationFtbListeMots('placer_les_mots',$tab_mots,$module_root,array('placer_les_mots'=>'gui_fo_evaluation_ftb_liste_mots.tpl'));
	 			$this->setComponent('placer_les_mots',$component);
	 		}
	 	}
	 	
	 	// prparation du texte et sa correction
	 	// NOTE : Rcupration du text en fonction de l'AMS reponse
	 	
	 	 //interpretation html 
	 	$text=get_ftb_libelle($langue_ams,$this->obj_EvaluationCorrection->obj_Evaluation->getText());
	 	/*
	    if($this->obj_EvaluationCorrection->obj_Evaluation->isInterpretationHtml()){
			//$text=htmlspecialchars($this->obj_EvaluationCorrection->obj_Evaluation->getText()) ;
			$text=$this->obj_EvaluationCorrection->obj_Evaluation->getText() ;
	    }
		else
			$text=$this->obj_EvaluationCorrection->obj_Evaluation->getText();
		*/
	 	
	 	
		
		// methode pour prendre en compte les doublons
	    $tabtext=explode($this->obj_EvaluationCorrection->obj_Evaluation->getBaliseEnd(),$text);
//	     print_rr($tabtext);
	    for($i=0;$i<$nb_tab_mots;$i++){

	        //on stocke la chaine  trouver ([: + mot)
	        $mot_src=$this->obj_EvaluationCorrection->obj_Evaluation->getBaliseStart().$tab_mots[$i];
	        
//	        // traitement liste de slection (plusieurs mots)
//	        $tab=explode("~",$tab_mots[$i]);
	        
	        $donnees_correction=$this->obj_EvaluationCorrection->getCorrectionElement($i);
	        //print_rr($donnees_correction);
	         
	        //on affiche la bonne rponse , le mot saisi et on indique si il est juste
	        //if(count($tab)==1){
	            if(empty($donnees_correction["saisi"])){
	            	$donnees_correction["saisi"]="vide";
	            }
	            if($donnees_correction["juste"]){
	            	$mot_affichage="<span style=\"color:#00CC00;text-decoration:underline;\">[".$donnees_correction["saisi"]."]&nbsp;</span>";
	            }else{
	            	$mot_affichage="<span style=\"color:#FF0000;text-decoration:line-through;\">[".$donnees_correction["saisi"]."]</span>&nbsp;<span style=\"color:#FF0000;font-weight:bold;\">".$donnees_correction["attendu"]."</span>";
	            }
//	        }else{
//	            if(empty($donnees_correction["saisi"])){
//	            	$donnees_correction["saisi"]="vide";
//	            }
//	            if($donnees_correction["juste"]){
//	            	$mot_affichage="<span style=\"color:#00CC00;text-decoration:underline;\">[".$donnees_correction["saisi"]."]&nbsp;</span>";
//	            }else{
//	            	$mot_affichage="<span style=\"color:#FF0000;text-decoration:line-through;\">[".$donnees_correction["saisi"]."]</span>&nbsp;<span style=\"color:#FF0000;font-weight:bold;\">".$donnees_correction["attendu"]."</span>";
//	            }	        	
//	            $show_word='f';
//	            shuffle($tab);
//	            $mot_affichage='<select name="reponse['.$i.']"><option value="">';
//	            for($m=0;$m<count($tab);$m++)
//	                $mot_affichage .='<option value="'.$tab[$m].'">'.$tab[$m].'</option>';
//	            $mot_affichage .='</select>';
//	        }
//	        print("\$mot_src=$mot_src   \$tabtext[$i]=$tabtext[$i]<br>");
//	        print("\$mot_affichage=$mot_affichage \$tabtext[$i]=$tabtext[$i]<br>");
	        //on remplace la chaine  trouver par un champ de saisie
	        $tabtext[$i]=str_replace($mot_src,$mot_affichage,$tabtext[$i]);
	        
	        
	    }
	    $affichage=implode('',$tabtext);
	    // les images
	     $affichage=eregi_replace("\[IMG file='([^]']*)'\]", "<img src=\"http://$serverfront/fo/data/contenus/\\1\">", $affichage);
	     // swf
	     // les swf
        $affichage=eregi_replace("\[SWF file='([^']*)'  hauteur='([0-9]*)' largeur='([0-9]*)'\]","<PARAM NAME=movie VALUE=\"http://$serverfront/data/contenus/\\1\" <PARAM NAME=quality VALUE=high><embed src=\"http://$serverfront/data/contenus/\\1\" quality=high pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\" type=\"application/x-shockwave-flash\" width=\"\\3\" height=\"\\2\"></embed>",$affichage);
	    //echo "point=$point<br>"; 
	    //echo "affichage=$affichage<br>";
	    $val['FTB_TEXTE_CORRIGE']=$affichage;
	    $val['TOTAL']=MSG_869;
	    $val['NOTE']=$note_ftb;
	    $val['NOTE_SUR']=$point;
	    $val['COMMENTAIRE']=MSG_157;
	    $val['EVALUATION_COMMENTAIRE']=$commentaire;
	    
	    $this->set_var($val);
	 	
	 }
		
	 
}  
?>
