<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui l'ensemble des lments ncessaire  la visualisation du formulaire.
 *
 * @package individu
 */
class guiFoIndividu extends PageComponent{
	/**
	 * @var object affichage des lments de saisie
	 */
	var $infos_texte;
	

	/**
	 * @var object affichage du select pour la selection de la langue
	 */
	var $select_langue;
	
	/**
	 * Constructeur
	 * 
	 * @param boolean $droit_detail TRUE affiche le detail, FALSE n'afficha pas le detail
	 * @param boolean $droit_utilisateur TRUE affiche tous les changement possible, FALSE n'affiche que les changement autoris pour un individu
	 * @param string $type L'identifiant individu exemple "f = formateur", "u = utilisateur" ou "i = intervenant".
	 * @param string $message Un texte d'erreur ou de validation d'enregistrement.
	 * @param boolean $erreur_etoile Un boolean TRUE = affiche l'etoile, FALSE = n'affiche pas l'etoile.
	 * @param integer $individu L'identifiant de l'individu
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
	 */
	function guiFoIndividu($individu,$module_root=null,$templates=null,$keep_login=true){
		global $chemin_bo,$langue_par_defaut;
		parent::PageComponent($module_root,$templates);
		
		//On creer l'affichage des champs de saisie du formulaire
		$this->infos_texte = new guiBoIndividuBase($individu,"$chemin_bo/individu/templates/tpl",array('infos_texte'=>'gui_bo_individu_base.tpl'),$keep_login);
		$this->setComponent('infos_texte',$this->infos_texte);
		if(!empty($individu))
			$user_lang=pg_fetch_result(get_individu($individu),0,12);
		else
			$user_lang=$langue_par_defaut;

		//On creer le select pour la selection de la langue.
		$this->select_langue = new guiBoSelectLangue('select_langue',$user_lang,"$chemin_bo/individu/templates/tpl",array('select_langue'=>'gui_bo_select_langue.tpl'));
		$this->setComponent('select_langue',$this->select_langue);
	}
}
?>