<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'affichage du formulaire de modification d'un individu.
 * 
 * @package individu
 */
class guiFoIndividuFormulaire extends PageComponent{
	/**
	 * @var object [] L'objet necessaire  l'affichage du formulaire de modification de l'individu.
	 */
	var $gui_fo_individu;
	
	/**
	 * Constructeur
	 * 
	 * @param integer $droit_detail L'identifiant des droits pour le detail de l'individu.
	 * @param integer $droit_utilisateur L'identifiant des droits de l'individu.
	 * @param string $type L'identifiant individu exemple "f = formateur", "u = utilisateur" ou "i = intervenant".
	 * @param string $message Un texte d'erreur ou de validation d'enregistrement.
	 * @param boolean $erreur_etoile Un boolean TRUE = affiche l'etoile, FALSE = n'affiche pas l'etoile.
	 * @param integer $individu L'identifiant de l'individu
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function guiFoIndividuFormulaire($individu,$module_root=null,$templates=null){
		global $chemin_fo;
		parent::PageComponent($module_root,$templates);
		
		$this->gui_fo_individu=new guiFoIndividu($individu,"$chemin_fo/individu/templates/tpl",array('champs_formulaire'=>'gui_fo_individu.tpl'));
		$this->setComponent('champs_formulaire',$this->gui_fo_individu);
		
		$val['$FORM_6']=FORM_6;
		parent::set_var($val);
	}
}
?>