<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Chargement de l'objet DoEtape appopri.
 * 
 * L'objet DoEtape en sortie de ce script peut etre:
 * - Le DoEtape correspondant  l'tape courante de la formation (celui stock dans l'objet DoFormation de la session)
 * - Un DoEtape spcifique, c'est  dire toute tape qui n'est pas l'tape courante (pass par l'URL avec la variable $sz_obj_doetape)
 * 
 * @param DoEtape $sz_obj_doetape Objet d'avancement de l'tape
 * 
 * @package etape
 */
 
//on recupere l'objet d'avancement de l'URL (Etape libre)
if(!empty($sz_obj_doetape)){
	$obj_DoEtape_URL=importObject($sz_obj_doetape,'LISTE_CURRENT_DO_ETAPE');
	$obj_DoEtape=&$obj_DoEtape_URL;
}

//on recupere l'objet d'avancement de la session (Etape courante)
if(is_object($obj_DoFormation)){
	$obj_DoEtape_SESSION=&$obj_DoFormation->getCurrentDoEtape();
	
	if($obj_DoEtape_URL){
		
		//l'tape  commencer est l'tape courante de la session identique  l'tape de l'url
		if(is_object($obj_DoEtape_SESSION)&&$obj_DoEtape_SESSION->compareTo($obj_DoEtape_URL)){

//			//debut de l'tape	
//			$obj_DoFormation->beginCurrentEtape();
			$obj_DoEtape=&$obj_DoFormation->getCurrentDoEtape();		
		}
	}
	//l'tape  commencer est l'tape courante de la session
	else{
//		//debut de l'tape	
//		$obj_DoFormation->beginCurrentEtape();
		$obj_DoEtape=&$obj_DoFormation->getCurrentDoEtape();		

	}
}
?>