<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affiche la correction des noeuds d'une Liste.
 * 
 * @param object CorrectionEtape $sz_obj_correction_etape  Objet de correction de l'tape de type Liste srialis.
 * @package liste
 */

//-----------------------------------------------------------
//					INCLUSIONS
//-----------------------------------------------------------
$dbpath="..";
require('../lib/identification.php3');
require("$chemin_bo/lib/lib_front_office.php");
require("$chemin_fo/lib_graphique/gui_evaluation/lib_evaluation.inc");
//pg_query("begin");
$NIVEAU_DEBUG=0;

//-----------------------------------------------------------
//					CONFIG PAGE
//-----------------------------------------------------------
$nompage="do_correction_liste.php";
$image="ongl_correction.gif";
$texte="Liste";
$path="..";
$styleCSS="../style/original.css";

//-----------------------------------------------------------
//					RECUPERATION OBJET DE CORRECTION
//				ET INITALISATION DES VARIABLES ASSOCIEES
//-----------------------------------------------------------

//on recupere l'objet d'avancement de l'URL 

if(!empty($sz_obj_correction_etape)){
	$obj_CorrectionEtape=importObjet($sz_obj_correction_etape);
}else{
	die("Erreur do_correction_liste.php : le parametre \$sz_obj_correction_etape est manquant.");
}

//on recupere l'objet de correction d'valuation associ  la correction de la liste
//print_rr($obj_CorrectionEtape);
//echo "coucou<br>";
$obj_CorrectionEvaluation=$obj_CorrectionEtape->getNextEvaluation($POST['indice_evaluation']);


//print_rr($obj_CorrectionEvaluation);

//redirection si fin des Evaluations de l'tape
if(!is_object($obj_CorrectionEvaluation)){

	header("location:../parcours.php");	
	exit();
	
}
//initialisation des variables utiles pour l'affichage 
else{
	//on cree l'objet graphique associ  la correction de l'valuation
	
	$gui_evaluation =guiEvaluationCorrectionFactory::createGuiEvaluation($obj_CorrectionEvaluation);
    
	//et les variables qui servent de "racouri"	
	$obj_etape=$obj_CorrectionEtape->getEtape($obj_DoFormation->obj_DoNodeFactory->getEtapeFactory());
	$type=$obj_CorrectionEtape->getType();
	$parcours=$obj_CorrectionEtape->getParcours();
	$formation=$obj_CorrectionEtape->getFormation();
	
	//libll
	$libelle=$gui_evaluation->obj_EvaluationCorrection->getLibelle();
	
	//libelle du type
	$libelle_type=$gui_evaluation->obj_EvaluationCorrection->getLibelleType();
	
	//commentaire 
	$commentaire=$gui_evaluation->obj_EvaluationCorrection->getCommentaire();
	
	//bareme
	$obj_bareme=$obj_etape->getObjBaremeEvaluation($obj_CorrectionEvaluation->getId());
	
	//points
	$points=$gui_evaluation->obj_EvaluationCorrection->getPoints();
}


//-----------------------------------------------------------
//					AFFICHAGE
//-----------------------------------------------------------

require("../en_tete.php");

print("
<!-- DEBUT do_correction_liste.php -->
<table class=\"tableau_contenu\">
<tr>
    <td>");

//Affichage titre Evaluation
include("$chemin_fo/lib_graphique/gui_evaluation/guiEvaluationEnTete.php");  

//Affichage du chrono
if(false && $_SESSION["chrono_".$obj_etape->getId()]!=-1){
	print("
	<table class=\"tableau_titre_serie\">
		<tr bgcolor=\"".$gui_evaluation->getCouleur()."\">");

    //si la srie a un chrono individuel
    if($_SESSION["chrono_".$obj_etape->getId()]==0){
        //on rcupre la dure du chrono pour l'exo  faire
        $sec=pg_result($res_serie,$indice_evaluation -1,'chrono');
    }
    else{
        //sinon on rcupere la dure de la srie commence par le stagiaire pour la formation
        $query="SELECT score FROM res_serie WHERE id_serie=$id_serie AND id_stag=$s_numstag AND id_formation=$s_numcal";
        $res=pg_query($query);
        $sec=-pg_result($res,0);
    }
    print("
			<script language=\"javascript\"> var secondes=$sec; </script>");

	print("
			<td class=\"barre_chrono_tableau_titre_serie\" colspan=\"3\">
				<img name=\"dm\" src=\"./new_chrono_images/ch0.gif\" classs=\"image_chrono_serie\" />
				<img name=\"m\" src=\"./new_chrono_images/ch0.gif\" width=\"20\" height=\"31\" hspace=\"0\" border=\"0\">
				<img src=\"./new_chrono_images/ch.gif\" width=\"20\" height=\"31\" hspace=\"0\" border=\"0\">
				<img name=\"ds\" src=\"./new_chrono_images/ch0.gif\" width=\"20\" height=\"31\" hspace=\"0\" border=\"0\">
				<img name=\"s\" src=\"./new_chrono_images/ch0.gif\" width=\"20\" height=\"31\" hspace=\"0\" border=\"0\">
			</td>
		</tr>
	</table>");
}


print("
   	</td>
</tr>
<tr>
	<td class=\"couleur_contenu_serie\">
		<table class=\"tableau_contenu_serie\">");
	
//affichage de l'evaluation	
//print_rr($gui_evaluation);
$gui_evaluation->affiche();

// Affichage du commentaire s'il existe
if(!empty($commentaire)){
	print("
			<tr bgcolor=\"#FFFFFF\">
				<td colspan=\"6\">
					<table class=\"tableau_contenu_avant_serie\">
						<tr>
							<td>
								<b><u>$MSG_157 :</u></b><br><br>$commentaire 
							</td>
						</tr>
					</table>
				</td>
			</tr>");
}
    
//formulaire
print("
			<form method=\"post\" name=\"formcorrexo\">");
			
//BARRE DE NAVIGATION
print("
			<tr bgcolor=\"#333399\">
				<td colspan=\"6\">
					<table align=\"center\">
						<tr>");
				
// Affichage du lien vers les tapes prcdentes				
print("				
							<td>");
if($indice_evaluation==1){
	print("
								&nbsp;");
}else{
	print("
								<a href=\"javascript:document.formcorrexo.indice_evaluation.value=(parseInt(document.formcorrexo.indice_evaluation.value))-1;document.formcorrexo.submit()\">
									<img src=\"../data/images/arriere.gif\">
								</a>");
}
print("
							</td>");

// Affichage du select pour un saut  un indice d'valuation donn
print("
							<td align=\"center\">
						        <select name=\"next_etape\" onChange=\"javascript:document.formcorrexo.indice_evaluation.value=this.options[this.selectedIndex].value;document.formcorrexo.submit()\">");

for($go=1;$go<=$nb_evaluations;$go++){
	if($indice_evaluation==$go){
		$selected="selected";
	}else{
		$selected="";
	}
	print("	        
									<option value=\"$go\" $selected>$MSG_1415s $go</option>");
}
print("
								</select>
								<input type=\"hidden\" name=\"indice_evaluation\" value=\"$indice_evaluation\">
							</td>");

// Affichage du lien vers les tapes suivantes
print("
							<td>");
if($indice_evaluation==$nb_evaluations){
	print("
								&nbsp;");
}else{
	print("        				
								<a href=\"javascript:document.formcorrexo.indice_evaluation.value=(parseInt(document.formcorrexo.indice_evaluation.value))+1;document.formcorrexo.submit();\">
									<img src=\"../data/images/avant.gif\">
								</a>");
}
print("
							</td>
						</tr>
					</table>
				</td>
			</tr>");

//fin formulaire
print("
			</form>
</table>");

//-----------------------------------------------------------
//					AFFICHAGE FIN DU TABLEAU
//-----------------------------------------------------------
include("$chemin_fo/lib_graphique/gui_parcours/parcours/tableau_etape_fin.php");  

//pg_query("rollback");
require("../pied_page.php");
print("
<!-- FIN do_correction_liste.php -->");
?>