<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Chargement de l'objet $obj_DoEvaluation appopri.
 * 
 * L'objet $obj_DoEvaluation en sortie de ce script peut etre:
 * - Le DoEtape correspondant  l'tape courante de la formation (celui stock dans l'objet DoFormation de la session)
 * - Un DoEtape spcifique, c'est  dire toute tape qui n'est pas l'tape courante (pass par l'URL avec la variable $sz_obj_doetape)
 * 
 * @param DoEtape $sz_obj_doetape Objet d'avancement de l'tape
 * 
 * @package etape
 */

if(!is_subclass_of($obj_DoEtape,'DoListe')){
	AstairsTemplate::setPageMessage('Operation non permise');
	header("location:../error_module.php");
	include("../pied_page.php");
}

if(is_object($obj_DoEtape)){
	$obj_DoEvaluation=&$obj_DoEtape->getCurrentDoEvaluation();
	if(is_object($obj_DoEvaluation)&&!$obj_DoEvaluation->isEnd()){
		messageDebug("Le DoEtape contient une valuation courrante");
	}else{
		messageDebug("Le DoEtape NE contient PAS une valuation courrante, on la recalcul");
		$obj_DoEvaluation=$obj_DoEtape->performCurrentEtape(new EtapeFactory());
	}
	messageDebugR("\$obj_DoEvaluation:",$obj_DoEvaluation);
	
	
	messageDebug("On initialise des variables<br>");
	$obj_etape=&$obj_DoEtape->getObjEtape();
	$parcours=$obj_DoEtape->getParcours();
	$formation=$obj_DoEtape->getFormation();
	$id=$obj_etape->getId();
	$type=$obj_etape->getType();
	if(empty($id)||empty($type)){
		die("Erreur reload_evaluation.php: valeurs manquantes:\$id=$id<br>  \$type=$type<br>");	
	}
	
	if(is_object($obj_DoEvaluation)){
		$points=$obj_etape->getPoints($obj_DoEvaluation->getEvaluation());
		$obj_bareme=$obj_etape->getObjBaremeEvaluation($obj_DoEvaluation->getEvaluation());
	}
		
}else{
	messageDebug("On a PAS de DoEtape donc pas de DoEvaluation");
	unset($obj_DoEvaluation);
}
?>