<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affiche le titre de la liste et un message indiquant son status.
 * 
 * @package serie
 */
 class guiFoDoListeDebut extends PageComponent{
 	/**
 	 * @param object[] $obj_DoEtape Objet de base servant  gerer l'avancement des tapes d'un parcours.
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
 	function guiFoDoListeDebut ($obj_DoListe,$module_root=null, $templates=null){
 		parent::PageComponent($module_root,$templates);
 		//echo "coucou<br>";
		$obj_liste = $obj_DoListe->getObjEtape();
//		print_rr($obj_DoListe);
		$val['LISTE_TITRE'] =get_fo_libelle($obj_liste->getLibelle());
		
		// TODO : test  revoir car isBegin retourne tjrs true
 		//On verifie si l'tape  commenc ou pas
 		$current_evaluation=$obj_DoListe->getCurrentDoEvaluation();
 		if(is_object($current_evaluation)&&$current_evaluation->getDebut()){
			$val['LISTE_STATUS_LIBELLE'] = MSG_1115." ".$obj_DoListe->getDebutFormate();
		}
		else{
			$val['LISTE_STATUS_LIBELLE'] =MSG_1492;
		}
		
		if($obj_DoListe->isEnd()){
//			echo "end";
//print_rr($obj_DoListe);
			$val['LISTE_STATUS_LIBELLE'] =MSG_1069." (".MSG_2205." :".$obj_DoListe->getDureeFormate().")";
			//$val['LISTE_STATUS_LIBELLE'] =MSG_1069." (dure actuellessss :".$obj_DoListe->getDuree().")";
		}
		
		
		switch($obj_DoListe->getStatus()){
			case DO_ETAPE_NONE:
				$val['LISTE_STATUS_REEL_LIBELLE'] =MSG_1068;
				break;
			case DO_ETAPE_BEGIN:
				if(!$obj_DoListe->isEnd()){
					$val['LISTE_STATUS_REEL_LIBELLE'] =MSG_1070;
				}else{
					$val['LISTE_STATUS_REEL_LIBELLE'] =MSG_2702;
				}
				break;
			case DO_ETAPE_END:
				$val['LISTE_STATUS_REEL_LIBELLE'] =MSG_2703;
				break;
			default:
				print("guiFoDoListeDebut(): Une erreur est survenue lors de la rcupration du status de l'tape.<br>");							
		}
 		
 		
 		$this->set_var($val);
 	}
 }
?>