<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le bouton Demarrer et le bouton de retour au parcours.
 * 
 * @package serie.
 */
 class guiFoDoListeFin extends PageComponent{
	/**
	 * @param object[] $obj_DoEtape Objet de base servant  gerer l'avancement des tapes d'un parcours.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet. 
	 */ 	
 	function guiFoDoListeFin($obj_DoListe,$module_root=null,$templates=null){
 		global $obj_DoFormation;
 		parent::PageComponent($module_root,$templates);
 		
 		
 		$liste_demarrer_url_base="../liste/do_liste.php";
 		$sz_obj_doetape=exportObject($obj_DoListe,'LISTE_CURRENT_DO_ETAPE');
 		
 		if(!$obj_DoListe->compareTo($obj_DoFormation->getCurrentDoEtape())){
 			$sliste_demarrer_url=$liste_demarrer_url_base."?sz_obj_doetape=$sz_obj_doetape";
 		}else{
 			$sliste_demarrer_url=$liste_demarrer_url_base;
 		}
 		
 		
 		
		if(!$obj_DoListe->isBegin()){
				$val['SERIE_DEMARRER_LIBELLE']=MSG_2650;
				$val['SERIE_DEMARRER_URL']=$sliste_demarrer_url;
				$val['SERIE_DEMARRER_OU']=MOT_2;
		}else{
			if($obj_DoListe->isBlocked()){
				$val['SERIE_DEMARRER_LIBELLE']='Vous n\'avez plus de tentative';
				$val['SERIE_DEMARRER_URL']='';
				$val['SERIE_DEMARRER_OU']='';
			}elseif($obj_DoListe->isNouvelleTentative()){
				$val['SERIE_DEMARRER_LIBELLE']='Recommencer';
				$val['SERIE_DEMARRER_URL']=$sliste_demarrer_url;
				$val['SERIE_DEMARRER_OU']=MOT_2;
			}elseif(!$obj_DoListe->isEnd()){
				$val['SERIE_DEMARRER_LIBELLE']=MSG_2649;
				$val['SERIE_DEMARRER_URL']=$sliste_demarrer_url;
				$val['SERIE_DEMARRER_OU']=MOT_2;
			}elseif($obj_DoListe->isCorrectionDisponible()){
				$val['SERIE_DEMARRER_LIBELLE']=MSG_2651;
				$val['SERIE_DEMARRER_URL']="../etape/correction_etape.php?sz_obj_do_etape=".$sz_obj_doetape;
				$val['SERIE_DEMARRER_OU']=MOT_2;
			}else{
				$val['SERIE_DEMARRER_LIBELLE']=MSG_2730;
				$val['SERIE_DEMARRER_URL']='';
				$val['SERIE_DEMARRER_OU']='';
			}
		}
 		
		
 		
 		$val['SERIE_RETOUR_LIBELLE']=MSG_2652;
	
 		$val['SERIE_RETOUR_LIBELLE_URL']="../parcours/parcours_action.php?action_target=./parcours.php&action_params=&sz_obj_doetape=$sz_obj_doetape";
 		parent::set_var($val);
 	}
 }
?>