<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'affichage d'une srie.
 * 
 * @package serie
 */
class guiFoListeDoElementsPage extends AstairsPageFo{
	/**
	 * @var object $debut Objet contenant les lments necessaire  l'affichage du debut du module.
	 */
	var $debut;
	
	/**
	 * @var object $contenu Objet contenant les lments necessaire  l'affichage du contenu du module.
	 */
	var $contenu;
	
	/**
	 * @var object $fin Objet contenant les lments necessaire  l'affichage de la fin du module.
	 */
	var $fin;
	 /**
	 * Constructeur
	 * 
	 * @param object[] $obj_DoListe Objet de base servant  gerer l'avancement des tapes d'un parcours.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet. 
	 */
	function guiFoListeDoElementsPage($obj_DoListe,$pageBuilder,$templates,$style_files, $javascript_files,$javascript_internal_code){
	 	parent::AstairsPageFo($pageBuilder,$templates,$style_files,$javascript_files,$javascript_internal_code);
		global $chemin_fo;

		$this->debut=new guiFoOnglet(MSG_1473,$obj_DoListe,"$chemin_fo/module/templates/tpl",array('liste_debut' => 'gui_fo_onglet.tpl'));
		$component=new guiFoListeDoElementsTexte('liste_texte',MSG_2631,$chemin_fo."/liste/templates/tpl",array('liste_texte'=>'gui_fo_liste_do_elements_texte.tpl'));
		
		$this->contenu=new guiFoListeDoElement($obj_DoListe,"$chemin_fo/liste/templates/tpl", array('liste_contenu' => 'gui_fo_liste_do_element.tpl'));
		
		$this->fin=new ModulePageFin("$chemin_fo/module/templates/tpl",array('liste_fin' => 'module_page_fin.tpl'));
		
		$this->setComponent('liste_debut', $this->debut);
		$this->setComponent('liste_texte', $component);
		$this->setComponent('liste_contenu', $this->contenu);
		$this->setComponent('liste_fin', $this->fin);
	}
}
?>
