<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit le menu de navigation de la plateforme.
 * 
 * @package module
 */
class ModulePageDebut extends PageComponent{
	
	/**
	 * @var object[] Objet graphique correspondant  l'onglet et aux flags de langues
	 */
	var $onglet;
	
	/**
	 * @var object[] Objet graphique contenant les lments d'affichage des boutons superieurs du menu de navigation.
	 */
	var $information;
	/**
	 * @var object[] Objet graphique contenant les lments d'affichage des boutons inferieur du menu de navigation.
	 */
	var $action;
	/**
	 * Constructeur
	 * 
	 * @param string $libelle_titre Le libelle du titre de la page.
	 * @param boolean $force_no_end Force  ne pas finir l'tape.
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une tape.
	 * @param integer $formation L'identifiant de la formation.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function ModulePageDebut($libelle_titre,$force_no_end,$obj_DoEtape,$formation,$module_root=null,$templates=null){
		
		global $chemin_fo,$MSG_2270,$root;
		parent::PageComponent($module_root,$templates);
		
		$this->onglet = new guiFoOnglet($libelle_titre,$obj_DoEtape,"$chemin_fo/module/templates/tpl",array('onglet' => 'gui_fo_onglet.tpl'));
		$this->setComponent('onglet',$this->onglet);	
		
		//creation de l'objet EnTeteParcoursModuleInformation inject dans le template module_page_debut.tpl
		$this->information = new EnTeteParcoursModuleInformation("$chemin_fo/parcours/templates/tpl",array('parcours_module_information' => 'en_tete_parcours_module_information.tpl'));
		$this->setComponent('parcours_module_information',$this->information);	
		
		//creation de l'objet EnTeteParcoursModuleAction inject dans le template module_page_debut.tpl
		$this->action = new EnTeteParcoursModuleAction($force_no_end,$obj_DoEtape,$formation,"$chemin_fo/parcours/templates/tpl",array('parcours_module_action' => 'en_tete_parcours_module_action.tpl'));
		$this->setComponent('parcours_module_action',$this->action);	
		
	}
}
?>