<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'onglet et les drapeaux d'une page de front office.
 * 
 * @package module
 */
class guiFoOnglet extends PageComponent{
	/**
	 * @var object[] Objet graphique contenant les lments permettant d'afficher les flag de la langue
	 */
	var $langue;
	/**
	 * Constructeur
	 * 
	 * @param string $libelle_titre Le libelle du titre de la page.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une tape.
 	 */
	function guiFoOnglet($libelle_titre,$obj_DoEtape,$module_root=null,$templates=null){
		global $chemin_fo,$MSG_2270,$root;
		parent::PageComponent($module_root,$templates);
		
		$val ['ONGLET_TITRE'] =$libelle_titre;
		$this->set_var($val);	
		
		//creation de l'objet PlateFormeLangues inject dans le template module_page_debut.tpl
		$this->langue = new PlateformeLangues('formation_langues',"$root/lib_graphique/objets/langue/templates/tpl",array('formation_langues' => 'plateforme_langues.tpl'),$obj_DoEtape);
		$this->setComponent('formation_langues',$this->langue);
	}
}
?>