<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le temps estim pour faire une tape.
 * 
 * @package ligne_etape
 */
 
class ColonneEtapeChrono extends Colonne{
	/**
	 * Affiche le temps d'estim pour faire l'tape.
	 * 
	 * @param string $chrono Le temps estim pour faire une tape. 
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function ColonneEtapeChrono( $chrono,$module_root=null,$templates=null){
		
		global $MSG_2256, $MSG_2257, $MSG_2258;
		parent::Colonne($module_root,$templates);
		//print_rr($chrono);
		if($chrono){
			$tmp=get_hms($chrono);
			//print_rr($tmp);
			if(!empty($tmp["heure"])){
				$heures=$tmp["heure"]."$MSG_2256&nbsp;";
				$affiche_chrono = $heures ;
			}
			if(!empty($tmp["minute"])||!empty($tmp["heure"])){
				$minutes=$tmp["minute"]."$MSG_2257&nbsp;";
				$affiche_chrono .=$minutes ;
			}
			if(!empty($tmp["seconde"])){
				$secondes=$tmp["seconde"]."$MSG_2258&nbsp;";
				$affiche_chrono .=$secondes ;
			}
			$val ['ETAPE_CHRONO'] =$affiche_chrono ;
		}
		parent::set_var($val);
	}
}
?>