<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le status de correction pour une etape serie.
 * 
 * @package ligne_etape
 */
class ColonneEtapeCorrection extends Colonne{
	/**
	 * Affichage du status de correction d'une etape serie
	 * 
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une tape.  
	 * @param object[] $obj_EtapeFactory Fabrique des objets associes aux objets d'avancements.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function ColonneEtapeCorrection($obj_DoEtape,&$obj_EtapeFactory,$module_root=null,$templates=null){
		
		global $MSG_1199,$MSG_976, $MSG_1100;
		parent::Colonne($module_root,$templates);
		
		$lien_serialise=exportObject($obj_DoEtape,"COR_ET".$obj_DoEtape->getFormation()."_".$obj_DoEtape->getParcours()."_".$obj_DoEtape->getEtape());
		
		//recup de l'objet Etape associ
		$obj_etape=$obj_DoEtape->getSrcEtape($obj_EtapeFactory);
		
		//si l'tape peut avoir une correction
		if(is_object($obj_etape)&&$obj_etape->isCorrectable()){	
			
			
			switch($obj_DoEtape->getStatus()){
				case DO_ETAPE_NONE:
					$status="&nbsp;";
					break;
				case DO_ETAPE_BEGIN:
					$status=" &nbsp;";
					break;
				case DO_ETAPE_END:
					$formation=$obj_DoEtape->getFormation();
					$parcours=$obj_DoEtape->getParcours();
					
					if($obj_DoEtape->isCorrected()){
						// on teste si serie bloquante et si correction disponible
						if($obj_DoEtape->isCorrectionDisponible())//$formation,$parcours
							$status="<a class=\"texte_lien_correction\" href=\"../etape/correction_etape.php?sz_obj_do_etape=".$lien_serialise."\">$MSG_1100 </a>";
						else
							$status= MSG_1199;
					}
					else{
						$status= MSG_976; 			
					}
				break;
				default:
					print("ColonneEtapeCorrection::ColonneEtapeCorrection(): Une erreur est survenue lors de la rcupration du status de l'tape.<br>");							
			}
		}else{
		//si l'tape ne peut pas avoir de correction
			$status="&nbsp;";	
		}

		$val ['ETAPE_CORRECTION_STATUS'] = $status;
		parent::set_var($val);
		
	}
}
?>