<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe charge d'affiche le libelle d'une etape libre ou obligatoire (avec un lien URL ou sans lien URL)
 * @colonne
 */
class ColonneEtapeLibelle extends Colonne{
	
	/**
	 * @param bool $obligatoire Indique si l'tape est obligatoire ou non.
	 * @param object $obj_DoEtape Objet contenant toutes les informations d'une tape courante.
	 * @param string $alias chaine de caractere qui affiche l'alias d'une etape.
	 * @param bool $current Indique si l'tape est en cours ou non.
	 * @param objext $obj_EtapeFactory Fabrique des objets associes aux objets d'avancements..
	 */
	function ColonneEtapeLibelle ( $obligatoire,$obj_DoEtape,$alias,$current,$obj_EtapeFactory,$module_root=null,$templates=null){
		
		
		parent::Colonne($module_root,$templates);

		//	recup de l'objet Etape associ
		$obj_etape=$obj_DoEtape->getSrcEtape($obj_EtapeFactory);
		if(is_object($obj_etape)){
			$libelle_etape=$obj_etape->getLibelle();
			$type=$obj_etape->getType();
			$type_court=get_etape_type_formate($type,1);
		}
		$alias=get_fo_libelle($alias);
		//On recupere le type
	 
		//recup du liens serialise
		//TODO mettre le lien dans l'objet'
		//if ($type_court == TYPE_ETAPE_FORUM){
			//$lien_serialise="../etape/etape_contrib.php?sz_obj_doetape".exportObjet($obj_DoEtape);
			//$lien_serialise="../etape/etape.php?sz_obj_doetape".exportObject($obj_DoEtape);
		//}else{
			$lien_serialise="../etape/etape.php?sz_obj_doetape=".exportObject($obj_DoEtape,'ET_LIB'.$obj_DoEtape->getFormation()."_".$obj_DoEtape->getParcours()."_".$obj_DoEtape->getEtape());
		//}
		
//		print_rr($obj_etape);
		if( 
		    //(is_subclass_of($this->obj_DoEtape,"DoListe")&&($this->obj_DoEtape->getStatus()!=DO_ETAPE_NONE)) ||
			(is_subclass_of($obj_DoEtape,"DoEtapeRenewable")&&($obj_DoEtape->getStatus()!=DO_ETAPE_NONE)) ||	//cas ou l'etape est toujours accessible aprs la premiere visite  
			($current) ||											//cas ou l'etape est la courante
			(!$obligatoire)										//cas ou l'etape est une tape libre
		){
			
			//cas ou l'etape est la courante
			if($current&&$obligatoire){
			
			$colonne_etape_libelle=new ColonneEtapeLibelleCourant($libelle_etape,$alias,$module_root,array('etape_libelle_valeurs' => 'colonne_etape_libelle_courant.tpl'));
			$this->setComponent('etape_libelle_valeurs',$colonne_etape_libelle);
			}
			//cas ou l'etape n'est pas l'tape courante
			else{
				$colonne_etape_libelle=new ColonneEtapeLibelleLien($lien_serialise,$libelle_etape,$alias,$module_root,array('etape_libelle_valeurs' => 'colonne_etape_libelle_lien.tpl'));
				$this->setComponent('etape_libelle_valeurs',$colonne_etape_libelle);
			}
		}
		else{
			$colonne_etape_libelle=new ColonneEtapeLibelleTexte($libelle_etape,$alias,$module_root,array('etape_libelle_valeurs' => 'colonne_etape_libelle_texte.tpl'));
			$this->setComponent('etape_libelle_valeurs',$colonne_etape_libelle);
		}	
	
	}

}
?>