<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le libelle u l'alias et le lien URL de l'tape courante.
 * 
 * @package ligne_etape.
 */ 		
class ColonneEtapeLibelleCourant extends Colonne{
	/**
	 * Affichage du libelle u de l'alias et le lien URL de l'tape courante.
	 * 
	 * @param string $libelle Le libelle de l'tape courante, si il y en a un.
	 * @param string $alias L'alias de l'tape courante, si il y en a un.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function ColonneEtapeLibelleCourant($libelle,$alias,$module_root=null,$templates=null){
		parent::Colonne($module_root,$templates);
		
		//Affiche le lien URL de l'etape courante.
		$lien ="../etape/etape.php";
		
		//Condition si l'on affiche l'alias ou le libelle
		 if(!empty($alias)){
			$val ['ETAPE_LIBELLE_VALEUR'] =get_fo_libelle($alias);
			$val ['ETAPE_URL'] =$lien;
		}else{
			$val ['ETAPE_LIBELLE_VALEUR'] =get_fo_libelle($libelle);
			$val ['ETAPE_URL'] =$lien;
		}
		parent::set_var($val);
	}
}
?>