<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le libelle ou l'alias et le lien serialize de l'tape.
 * 
 * @package ligne_etape. 
 */
class ColonneEtapeLibelleLien extends Colonne{
	/**
	 * Affichage du libelle ou de l'alias et le lien serialize de l'tape.
	 * 
	 * @param string $lien_serialise Le lien serialis de l'tape.
	 * @param string $libelle Le libelle de l'tape, si il y en a un.
	 * @param string $alias L'alias de l'tape, si il y en a un.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function ColonneEtapeLibelleLien ($lien_serialise,$libelle,$alias,$module_root=null,$templates=null){
	
		parent::Colonne($module_root,$templates);
		
		//Condition si l'on affiche l'alias ou le libelle.
		 if(!empty($alias)){
			$val ['ETAPE_LIBELLE_VAL'] =get_fo_libelle($alias);
			$val ['ETAPE_LIBELLE_URL'] =$lien_serialise;
		}else{
			$val ['ETAPE_LIBELLE_VAL'] =get_fo_libelle($libelle);
			$val ['ETAPE_LIBELLE_URL'] =$lien_serialise;
		}
		parent::set_var($val);
	}
}
?>