<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le libelle ou l'alias de l'tape sans lien.
 * 
 * @package ligne_etape. 
 */
class ColonneEtapeLibelleTexte extends Colonne{
	/**
	 *Affichage du libelle ou de l'alias de l'tape
	 *
	 * @param string $libelle Le libelle de l'etape, si il y en a un.
	 * @param string $alias L'alias de l'tape, si il y en a un.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function ColonneEtapeLibelleTexte($libelle,$alias,$module_root=null,$templates=null){
		parent::Colonne($module_root,$templates);
		//echo "lib=$libelle<br>";
		//Si il y a un alias on l'affiche, sinon on affiche le libelle.
		 if(!empty($alias)){
			$val ['ETAPE_LIBELLE_VALEUR'] =get_fo_libelle($alias);

		}else{
			$val ['ETAPE_LIBELLE_VALEUR'] =get_fo_libelle($libelle);
		}
	parent::set_var($val);
	}
}
?>