<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Classe charge d'affiche l'icone d'obligation (obligatoire ou libre) d'une tape.
 * @colonne
 */
class ColonneEtapeObligation extends Colonne{
	
	
	/**
	 * @param bool $obligation Indique si l'tape est obligatoire ou non.
	 * @param string $couleur Couleur d'affichage de la colonne.
	 */
	function ColonneEtapeObligation($obligation,$module_root=null,$templates=null){
		
		parent::Colonne($module_root,$templates);
		
		if($obligation) {
			$colonne_etape_obligation=new ColonneEtapeObligatoire($module_root,array('obligation_colonne' => 'colonne_etape_obligatoire.tpl'));
			$this->setComponent('obligation_colonne', $colonne_etape_obligation);
		}
		else{
			$colonne_etape_obligation=new ColonneEtapeLibre($module_root,array('obligation_colonne' => 'colonne_etape_libre.tpl'));
			$this->setComponent('obligation_colonne', $colonne_etape_obligation);
		}
		
	}
	
}

?>