<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'affichage pour le status visuel de l'icone de validation de l'etape.
 * 
 * @package ligne_etape.
 */
class ColonneEtapeReset extends Colonne{
	/**
	 * Constructeur
	 * 
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une �tape.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function ColonneEtapeReset($obj_DoEtape,$module_root=null,$templates=null){
		
		parent::Colonne($module_root,$templates);
		$id=$obj_DoEtape->getEtape();
		
		$val['ETAPE_RESET_LIBELLE']='RAZ ETAPE';
		$val['ETAPE_RESET_URL']='../etape/etape_raz.php?obj_reset_etape='.exportObject($obj_DoEtape,'etape_to_reset_'.$id);
		
		$this->set_var($val);
	}
}
?>