<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'affichage pour le status visuel de l'icone de validation de l'etape.
 * 
 * @package ligne_etape.
 */
class ColonneEtapeStatus extends Colonne{
	/**
	 * Constructeur
	 * 
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une tape.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function ColonneEtapeStatus($obj_DoEtape,$module_root=null,$templates=null){
		
		global $MSG_1068,$MSG_1070,$MSG_1069;
		parent::Colonne($module_root,$templates);
		
		
		switch($obj_DoEtape->getStatus()){
			case DO_ETAPE_NONE:
				$colonne_etape_status=new ColonneEtapeStatusNone($module_root,array('status' => 'colonne_etape_none.tpl'));
				$this->setComponent('status', $colonne_etape_status);
				break;
			case DO_ETAPE_BEGIN:
				$colonne_etape_status=new ColonneEtapeStatusBegin($module_root,array('status' => 'colonne_etape_begin.tpl'));
				$this->setComponent('status', $colonne_etape_status);
				break;
			case DO_ETAPE_END:
				$colonne_etape_status=new ColonneEtapeStatusEnd($module_root,array('status' => 'colonne_etape_end.tpl'));
				$this->setComponent('status', $colonne_etape_status);
				break;
			default:
				print("ColonneEtapeStatus::ColonneEtapeStatus(): Une erreur est survenue lors de la rcupration du status de l'tape.<br>");							
		}
	}
}
?>