<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le libelle du type de l'etape, ainsi que le numero d'icone correspondant au type de l'tape.
 * 
 * @package ligne_etape.
 */ 
class ColonneEtapeType extends Colonne{
	/**
	 * @param string $libelle_type Le libelle de l'tape.'
	 * @param string $libelle_type_original Le libelle titre de l'tape.
	 * @param integer $type L'identifiant du type de l'tape.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function ColonneEtapeType($libelle_type,$libelle_type_original,$type,$module_root=null,$templates=null){

		parent::Colonne($module_root,$templates);		
		
		$libelle_type=get_fo_libelle($libelle_type);
		
		$val ['ETAPE_TYPE'] =$libelle_type;
		$val ['ETAPE_LIBELLE_TYPE_ORIGINAL'] =$libelle_type_original;
		//$val ['ETAPE_LIBELLE_TYPE_ORIGINAL'] =$libelle_type;
		$val ['ETAPE_TYPE_ICO'] =$type;
		parent::set_var($val);
	}
}
?>