<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche les boutons inferieur de l'entete des pages(le menu de navigation).
 */
class EnTeteParcoursModuleAction extends PageComponent{
	/**
	 * Affiche les boutons au niveau inferieur de l'entete des pages(le menu de navigation).
	 * 
	 * @param boolean $forece_no_end Force  ne pas finir l'tape
	 * @param object[] $obj_DoEtape Objet contenant toutes les informations d'une tape.
	 * @param integer $formation L'identifant de la formation
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function EnTeteParcoursModuleAction ($force_no_end,$obj_DoEtape,$formation,$module_root=null,$templates=null ){
		global $MSG_926,$MSG_928,$MSG_927,$MSG_196,$MSG_727,$MSG_1210;
		parent::PageComponent($module_root,$templates);
		
		//TODO  faire vrifier par Rmi
		//On recupere un boolean qui nous si il y a une ressource nouvelle dans la formation
		$res_ressources_nouveaute = get_formation_ressources_nouveaute($formation);
		$row_ressources_nouvelle = pg_fetch_row($res_ressources_nouveaute);	
		
		//Si il y a une une nouveaute il affiche l'icone ressource_new sinon il affiche l'icone ressource
		if(sql2Bool($row_ressources_nouvelle[0])){
			$ressource = "ressource_new";
//			$ressource = "ressource";	
		}else{
			$ressource = "ressource";			
		}
		
		//Tableau contenant le nom, le lien url et l'id du css de l'ensemble des boutons inferieurs du menu
		$btn_action = array(
		'forum' => array($MSG_926=>'../parcours/parcours_action.php?force_no_end='.$force_no_end.'&action_target=../forum/forum.php&action_params=&sz_obj_doetape='.exportObject($obj_DoEtape,'CURRENT_DO_ETAPE').''),
		'chat' =>array($MSG_928=>'../chat/chat.php') ,
		$ressource => array($MSG_927=>'../parcours/parcours_action.php?force_no_end='.$force_no_end.'&action_target=../ressource/ressource.php&action_params=&sz_obj_doetape='.exportObject($obj_DoEtape,'CURRENT_DO_ETAPE').''),
		'presentiel' =>array($MSG_196=>'../parcours/parcours_action.php?force_no_end='.$force_no_end.'&action_target=../presentiel/presentiel.php&action_params=&sz_obj_doetape='.exportObject($obj_DoEtape,'CURRENT_DO_ETAPE').''),
		'parcours' => array($MSG_727=>'../parcours/parcours_action.php?force_no_end='.$force_no_end.'&action_target=./parcours.php&action_params=&sz_obj_doetape='.exportObject($obj_DoEtape,'CURRENT_DO_ETAPE').''),
		'stats' =>array( $MSG_1210=>'#')
		);
		//../stats/stats.php
		//On boucle sur le tableau afin d'afficher tous les boutons
		parent::set_block('parcours_module_action','barre_action','bloc_module_action');
		foreach($btn_action as $key => $val){
			parent::set_var('MODULE_ACTION_ID',$key);
			foreach($val as $action_lib => $action_lien){
				parent::set_var('MODULE_ACTION_LIB',$action_lib);
				parent::set_var('MODULE_ACTION_LIEN',$action_lien);
				Template::parse('bloc_module_action','barre_action',true);
			}
		}
	}
}
?>