<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche les boutons superieur de l'entete des pages(le menu de navigation).
 */
class EnTeteParcoursModuleInformation extends PageComponent{
	/**
	 * Affichage des boutons superieur de l'entete des pages(le menu de navigation).
	 * 
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function EnTeteParcoursModuleInformation ($module_root=null,$templates=null ){
		global $MSG_1984,$MSG_2356,$MSG_1038,$MSG_2187;
		parent::PageComponent($module_root,$templates);
		
		//Le tableau $btn_info contient le nom, le lien url et l'id pour le css des boutons superieur du menu		
		$btn_info = array(
		'accueil'=>array($MSG_1038 =>'../accueil/accueil.php?change_formation=1'),
		'calendrier'=>array($MSG_2356=>'../parcours/parcours_action.php?force_no_end=&action_target=../calendrier/calendrier.php&action_params=&sz_obj_doetape='),
		'annuaire'=>array($MSG_2187=>'../parcours/parcours_action.php?force_no_end=&action_target=../annuaire/annuaire.php&action_params=&sz_obj_doetape=')
		);
		
		//affichage du bouton aide ( il est  part car son lien est particulier, il vise vers une popup)
		$val['MODULE_LIEN_AIDE'] = "#";
		$val['TITRE_AIDE'] = $MSG_1984;
		$val['POPUP_LIEN'] = "popup('../aide/aide.php','$MSG_1984','width=800,height=850,menubar=no,status=no,scrollbars=yes,top=10,left=10',false);";		
		$val['MODULE_LIB_AIDE'] = $MSG_1984;
		parent::set_var($val);
		
		//On boucle sur le tableau des bouton avec leur valeur et les liens respectifs
		parent::set_block('parcours_module_information','barre_module','bloc_module_information');
		foreach($btn_info as $key =>$val){
			parent::set_var('MODULE_ID',$key);
			foreach($val as $module_lib => $module_lien ){
				parent::set_var('MODULE_LIB',$module_lib);
				parent::set_var('MODULE_LIEN',$module_lien);
				Template::parse('bloc_module_information','barre_module',true);
			}
		}
		
	}
}
?>