<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette classe est charg�e de la construction d'une ligne d'�tape du Parcours.
 * Un  LigneEtape est form� de diff�rents objets d�riv�s de la classe Colonne.
 * Aisi, une ligne est form�e de plusieurs Colonnes.
 * Ces colonnes sont,dans l'ordre:
 * ColonneEtapeObligation | ColonneType | ColonneLibelle | ColonneEtapeStatus | ColonneEtapeChrono | ColonneEtapeCorrection
 * 
 * La LigneEtape poss�de une unique m�thode en plus de son constructeur, affiche(), qui affiche la ligne.
 * 
 * @package LigneEtape
 */
class LigneEtape extends PageComponent{
	
	/**
	 * Constucteur.
	 *  
	 * @param DoFormation $obj_DoFormation 
	 * @param integer $parcours 
	 * @param DoEtape &$obj_DoEtape
	 * @param string $alias 
	 * @param integer $type 
	 * @param string $libelle_type 
	 * @param string $libelle_type_original 
	 * @param bool $obligation Indique si l'�tape est obligatoire ou non.
	 * @param integer $chrono valeur en seconde, du chrono de l'�tape.
	 * @param bool�en $fin �tape fin de page
	 * @param string $couleur Couleur d'affichage de la colonne.
	 * @param EtapeFactory $obj_EtapeFactory Fabrique de
	 */
	function LigneEtape($obj_DoFormation, $parcours,&$obj_DoEtape,$alias,$type, $libelle_type,$libelle_type_original, $obligatoire,$chrono,$fin, $couleur,&$obj_EtapeFactory,$module_root=null,$templates=null){
		global $MSG_2551,$MSG_727, $MSG_1741,$MSG_926,$MSG_1473, $MSG_1689, $MSG_2225, $MSG_2226,$MSG_2227,$MSG_2228,$MSG_776, $MSG_922, $MSG_927b , $MSG_928, $MSG_516, $MSG_2223, $MSG_1372, $MSG_1483 ,$MSG_547;
		
		parent::PageComponent($module_root,$templates);
		//echo "type=$type<br>";
		$val ['LINE_COLOR'] = $couleur;
		parent::set_var($val);
		//echo "libelle_type=$libelle_type<br>";	

		//traitement sur le libell� � afficher
		if(empty($libelle_type)){
			$var='$libelle_type='.$libelle_type_original.';';
			eval($var);
			
			//si c'est un type compos�, on enleve le '-' qui est au d�but du type
			if(substr_count($type,'_')>=2){
				$debut_type=strpos($libelle_type,'-');
				$libelle_type=substr($libelle_type,$debut_type+1);
			}
		}
		
		//traitement sur le libell� � afficher
		if(!empty($libelle_type_original)){
			$var='$libelle_type_original='.$libelle_type_original.';';
			eval($var);
			
			//si c'est un type compos�, on enleve le '-' qui est au d�but du type
			/*
			echo "type=$type<br>";
			if(substr_count($type,'_')>=2){
				$debut_type=strpos($libelle_type,'-');
				$libelle_type=substr($libelle_type,$debut_type+1);
			}
			*/
		}
		
		
		//calcul du chrono
		//on prend le chrono configur sinon on prend le chrono de la srie
		$obj_etape=$obj_DoEtape->getSrcEtape(new EtapeFactory());
		if(is_object($obj_etape)){
			
			if(empty($chrono)&&$obj_etape->isChronometrable()){
				
				//echo "toto";
				//print_rr($obj_etape);
				$chrono=$obj_etape->getChrono();
				//echo "\$chrono=$chrono";
			}
		}
		
		//echo "libelle_type=$libelle_type<br>";
		//savoir si l'etape est l'etape courante de l'avancement de la formation
		messageDebug("Comparaison de l'�tape courante et de l'�tape courante de la formation");
		messageDebugR("Etape courante de l'avancement:",$obj_DoFormation->getCurrentDoEtape());
		messageDebugR("Etape de la LigneEtape:",$obj_DoEtape);
		$current=false;
		if($obj_DoEtape->compareTo($obj_DoFormation->getCurrentDoEtape())){
			$current=true;
		}

		
		
		$colonne_etape_obligation=new ColonneEtapeObligation($obligatoire,$module_root,array('colonne_etape_obligation' => 'colonne_etape_obligation.tpl'));
		$this->setComponent('colonne_etape_obligation', $colonne_etape_obligation);
		$colonne_etape_type=new ColonneEtapeType($libelle_type,$libelle_type_original,$type, $module_root,array('colonne_etape_type' => 'colonne_etape_type.tpl'));
		$this->setComponent('colonne_etape_type', $colonne_etape_type);
		$colonne_etape_libelle=new ColonneEtapeLibelle($obligatoire,$obj_DoEtape,$alias,$current,$obj_EtapeFactory,$module_root,array('colonne_etape_libelle' => 'colonne_etape_libelle.tpl'));
		$this->setComponent('colonne_etape_libelle', $colonne_etape_libelle);
		$colonne_etape_status=new ColonneEtapeStatus($obj_DoEtape,$module_root,array('colonne_etape_status' => 'colonne_etape_status.tpl'));
		$this->setComponent('colonne_etape_status', $colonne_etape_status);
		$colonne_etape_chrono=new ColonneEtapeChrono($chrono,$module_root,array('colonne_etape_chrono' => 'colonne_etape_chrono.tpl'));
		$this->setComponent('colonne_etape_chrono', $colonne_etape_chrono);
		$colonne_etape_correction=new ColonneEtapeCorrection($obj_DoEtape,&$obj_EtapeFactory,$module_root,array('colonne_etape_correction' => 'colonne_etape_correction.tpl'));
		$this->setComponent('colonne_etape_correction', $colonne_etape_correction);
		
		$status=$obj_DoEtape->getStatus();
		if($status!=DO_ETAPE_NONE){
			$colonne_etape_reset=new ColonneEtapeReset($obj_DoEtape,$module_root,array('colonne_etape_reset' => 'colonne_etape_reset.tpl'));
			$status=$obj_DoEtape->getStatus();
		}else{
			$colonne_etape_reset=new ColonneEtapeVide($module_root,array('colonne_etape_reset' => 'colonne_etape_vide.tpl'));
		}
		$this->setComponent('colonne_etape_reset', $colonne_etape_reset);
	}
}
?>