<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

 /**
  * Cette class permet de creer une Ligne tape titre  ou une ligne tape.
  * 
  * @package ligne_etape
  */
class LigneEtapeFactory{
	/**
	 * Creer une ligne tape titre ou une ligne tape.
	 * 
	 * @param object[] $obj_DoFormation Objet de base servant  gerer l'avancement d'une Formation.
	 * @param integer $parcours L'identifiant du parcours.
	 * @param object[] $obj_DoEtape Objet de base servant  gerer l'avancement des tapes d'un parcours.
	 * @param string $alias L'alias de l'tape.
	 * @param integer $type l'identifiant du type d'une tape.
	 * @param string $libelle_type Le libelle du type de l'tape.
	 * @param string $libelle_type_original Le libelle du type original de l'tape.
	 * @param boolean $obligatoire Indique si l'tape est obligatoire ou non.
	 * @param string $chrono Le temps estim pour faire une tape.
	 * @param $fin A completer
	 * @param integer $couleur L'identifiant de couleur.A verifier
	 * @param object[] $obj_EtapeFactory Fabrique des objets associes aux objets d'avancements.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function createLigneEtape($obj_DoFormation, $parcours,&$obj_DoEtape, $alias,$type,$libelle_type,$libelle_type_original, $obligatoire,$chrono,$fin, $couleur,&$obj_DoEtapeFactory,$module_root=null,$target_template=null){
		global $chemin_fo;
			
			
		//cas ou l'tape est dconnecte
		//recup de l'objet Etape associ
		$obj_etape=$obj_DoEtape->getSrcEtape(new EtapeFactory());
		if(!is_object($obj_etape)||$obj_etape->getId()==null){
			return new LigneEtapeTitre($obj_DoEtape, $alias,"$chemin_fo/parcours/templates/tpl",array($target_template => 'ligne_etape_titre.tpl')," est temporairement inaccessible.");
		}	
				
		switch ($obj_DoEtape->getType()) {
			case TYPE_ETAPE_TITRE:
				return new LigneEtapeTitre($obj_DoEtape, $alias,"$chemin_fo/parcours/templates/tpl",array($target_template => 'ligne_etape_titre.tpl'));
				
			/*case TYPE_ETAPE_PARCOURS_ORIENTE :
				return new LigneEtapeParcoursOriente($obj_DoEtape, $alias);*/
			
				break;
			default:
				return new LigneEtape($obj_DoFormation,$parcours,&$obj_DoEtape, $alias,$type,$libelle_type,$libelle_type_original,$obligatoire,$chrono,$fin, $couleur,&$obj_DoEtapeFactory,"$chemin_fo/parcours/templates/tpl",array($target_template => 'ligne_etape.tpl'));
		}
	}
}
?>