<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche le libelle de la ligne tape titre.
 * 
 * @package ligne_etape.
 */ 
class LigneEtapeTitre extends PageComponent{
	/**
	 * Affichage du libelle de la ligne tape titre.
	 * 
	 * @param object[] $obj_DoEtape Objet de base servant  gerer l'avancement des tapes d'un parcours.
	 * @param string $alias L'alias de l'tape titre.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
	function LigneEtapeTitre($obj_DoEtape,$alias,$module_root=null,$templates=null, $texte_special=""){

		parent::PageComponent($module_root,$templates);		
	    
//	 	$val ['LINE_COLOR'] = "4";
	   
		if(empty($alias)){
			$val ['COLONNE_ETAPE_LIBELLE']=get_fo_libelle($obj_DoEtape->getLibelle()).$texte_special;
		}else{		
			$val ['COLONNE_ETAPE_LIBELLE']=get_fo_libelle($alias).$texte_special;
		}
		parent::set_var($val);
	}
}
?>