<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit l'ensemble de la page parcours.
 * Elle contient: 
 * le parcours module debut
 * le parcours module contenu
 * le parcours module fin
 * 
 * @package parcours
 */
class ParcoursModule extends PageComponent{
	/**
	 * @var object Objet graphique contenant le module debut
	 */
	var $debut;
	/**
	 * @var object Objet graphique contenant le module contenu
	 */
	var $contenu;
	/**
	 * @var object Objet graphique contenant le module fin
	 */
	var $fin;	
	/**
	 * Constructeur
	 * 
	 * @param object[] $obj_DoFormation Objet contenant toutes les informations de la formation.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function ParcoursModule($obj_DoFormation,$module_root=null,$templates=null){
		global $chemin_fo;
		
		parent::PageComponent($module_root,$templates);
		
		$this->debut =new ParcoursModuleDebut( $obj_DoFormation,"$chemin_fo/parcours/templates/tpl",array('debut_module' => 'parcours_module_debut.tpl'));
		$this->setComponent( 'debut_module',$this->debut);
	
		$this->contenu =new ParcoursModuleContenu('contenu_module',$obj_DoFormation,"$chemin_fo/parcours/templates/tpl",array('contenu_module' => 'parcours_module_contenu.tpl'));
		$this->setComponent('contenu_module',$this->contenu);
	
		$this->fin =new ParcoursModuleFin("$chemin_fo/parcours/templates/tpl",array('fin_module' => 'parcours_module_fin.tpl'));
		$this->setComponent('fin_module',$this->fin);
	}
}
?>