<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui affiche  l'etat graphique l'avancement d'un individu sur le parcours.
 * 
 * @package parcours
 */ 
class ParcoursModuleAvancement extends PageComponent{
	/** 
	 * Affichage graphique de l'avancement.
	 * 
	 * @param integer $nb_etapes_faites Le nombre d'tape effectu par l'individu.
	 * @param integer $nb_etapes Le nombre total d'etape sur le parcours.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function ParcoursModuleAvancement($nb_etapes_faites, $nb_etapes,$module_root=null,$templates=null){
		global $MSG_1317;
		parent::PageComponent($module_root,$templates);
		
		$val['PARCOURS_NB_ETAPES_LABEL']=$MSG_1317;
		$val['PARCOURS_NB_ETAPES_FAITES']=$nb_etapes_faites;
		$val['PARCOURS_NB_ETAPES']=$nb_etapes;
		if($nb_etapes>0)
			$val['AVANCEMENT_POURCENTAGE']=(int)(($nb_etapes_faites/$nb_etapes)*100);
		else
			$val['AVANCEMENT_POURCENTAGE']=(int)(($nb_etapes_faites/1)*100);
		
		parent::set_var($val);
	}
}
?>
