<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit la ou les titres ligne etape ainsi que les ligne etape.
 * 
 * @package parcours
 */
class ParcoursModuleContenu extends PageComponent{
	/**
	 * Constructeur
	 * 
	 * @param string $block_target Le nom de la variable qui contiendra la boucle dans le tpl.
	 * @param object[] $obj_DoFormation Objet contenant toutes les informations de la formation.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function ParcoursModuleContenu($block_target,$obj_DoFormation,$module_root=null,$templates=null){
	
		parent::PageComponent($module_root,$templates);
		
		$parcours=$obj_DoFormation->getParcours();
		$res_etapes=$obj_DoFormation->getEtapes(); 
		$nb_etapes=pg_num_rows($res_etapes);
		// modif said du 14/02/08
		// pour la barre d'avancement on recupre les etapes  faire rellement
		$res_etapes_reelles=$obj_DoFormation->getEtapesReelles();
		$nb_etapes_reelles=pg_num_rows($res_etapes_reelles);
		
		// recup des etapes faites par l'individu
		//$res_etape_individu=get_formation_avancement_individu($obj_DoFormation->getFormation(),$obj_DoFormation->getIndividu());
		// modif said du 14/02/08
		// Ici de mme on rcupre les etapes rellement faites par l'individu
		$res_etape_individu=get_formation_avancement_reel_individu($obj_DoFormation->getFormation(),$obj_DoFormation->getIndividu());
		$nb_etapes_faites=pg_num_rows($res_etape_individu);
		$res_etape_individu=get_formation_evolution_reelle_individu($obj_DoFormation->getFormation(),$obj_DoFormation->getIndividu());
		$row_etape_individu=pg_fetch_row($res_etape_individu,0);
		$nb_etapes_faites=$row_etape_individu[0];
		$nb_etapes_reelles=$row_etape_individu[1];
	
		$obj_DoEtapeFactory=$obj_DoFormation->getDoEtapeFactory();
		$obj_EtapeFactory=$obj_DoEtapeFactory->getEtapeFactory();
		
		$avancement = new ParcoursModuleAvancement($nb_etapes_faites,$nb_etapes_reelles,$module_root,array('parcours_avancement' => 'parcours_module_avancement.tpl'));
		$this -> setComponent('parcours_avancement',$avancement);
		
		$module_titre_ligne_etape = new ParcoursModuleTitreLigneEtape($module_root,array('parcours_titre_ligne_etape' => 'parcours_module_titre_ligne_etape.tpl'));
		$this -> setComponent('parcours_titre_ligne_etape',$module_titre_ligne_etape);
		
		parent::set_block($block_target,'etapes','bloc_etapes');
		for($i=0;$i<$nb_etapes;$i++){
			$row=pg_fetch_row($res_etapes);
			//print_rr($row);
			//echo "row4=$row[4]<br>";
			//creation de l'etape
			$cur_etape=$obj_DoFormation->obj_DoNodeFactory->createDoEtape($row[6],$row[0],get_etape_type_formate($row[4],1));
//			print_rr($cur_etape);
			//creation de la ligne
			if($cur_etape){
				$obj_ligne=LigneEtapeFactory::createLigneEtape($obj_DoFormation,$parcours,$cur_etape, $row[1],$row[4],$row[3],$row[10],sql2bool($row[7]),$row[8],$row[9],$i%2,$obj_EtapeFactory,$module_root,'etape');
				$this->setComponent('etape',$obj_ligne,true,'etapes','bloc_etapes');
			}else{
				echo "aie";
			}
		}
	}
}
?>