<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Class qui construit le Module Individu.
 * 
 * @package parcours
 */
class ParcoursModuleDebut extends PageComponent{
	/**
	 * @var object Objet graphique contenant le parcours module individu
	 */
	var $user;
	/**
	 * Constructeur
	 * 
	 * @param object[] $obj_DoFormation Objet contenant toutes les informations de la formation.
	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
	function ParcoursModuleDebut($obj_DoFormation,$module_root=null,$templates=null){
		
		parent::PageComponent($module_root,$templates);
		//On recupere le numero de l individu
		$id_individu = $obj_DoFormation->getIndividu();
		$url_formulaire="../parcours/parcours_action.php?force_no_end=&action_target=../individu/individu.php"; 
		$user = new guiFoIndividuEdition($id_individu,$url_formulaire,$module_root,array('parcours_module_individu' => 'en_tete_parcours_module_individu.tpl'));
		$this->setComponent('parcours_module_individu',$user);
	}
}
?>
