<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche le nom et prenom de l'individu
 * 
 * @package presentiel
 */
  class guiFoPresentielContenuDebut extends PageComponent{
 	
 	/**
 	 * Affiche le prefixe, nom et prnom de l'individu
 	 * 
 	 * @param integer $individu L'identifiant d'individu
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param srting[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoPresentielContenuDebut($formation,$individu,$module_root=null,$templates=null){
		global $chemin_fo,$MSG_2324; 		
 		parent::PageComponent($module_root,$templates);
 		
 		//Recupere le nombre de date pour effectuer un colspan dynamique.
 		$resdate=get_formation_evenements_presentiels($formation);
		$nbdate=pg_num_rows($resdate);
 		$nbcolonne = $nbdate + 1;//On ajoute 1 car il faut compte la cellule ou est place le libelle "Date".
 		
 		//On recupere le nom et prenom de l'individu
 		$resstag=get_individu_nom_prenom($individu);
		$rowstag=pg_fetch_row($resstag,0);
		$nomstag=$rowstag[1];
		$prenomstag=$rowstag[2];
		
		//On injecte dans les variables du tpl.
		$val['NOMBRE_COLONNE']=$nbcolonne;
		$val['LIBELLE_INDIVIDU']=$MSG_2324.":";
		$val['INDIVIDU_NOM']=$nomstag;
		$val['INDIVIDU_PRENOM']=$prenomstag;
		parent::set_var($val);
 	}
 }
?>