<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class construit le select qui ce trouve en bas de la page.
 * 
 * @package presentiel
 */
  class guiFoPresentielContenuFin extends PageComponent{
 	/**
 	 * @param integer $formation L'identifiant de la formation.
 	 * @param string $resgrille 
 	 * @param integer $nbgrille Le nombre de grille
 	 * @param integer $grille L'identifiant de la grille
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis.
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet.
 	 */
 	function guiFoPresentielContenuFin($formation,$resgrille,$nbgrille,$grille,$module_root=null,$templates=null){
		global $chemin_fo,$MSG_971; 		
 		parent::PageComponent($module_root,$templates);
 		
 		//Recupere le nombre de date pour effectuer un colspan dynamique.
 		$resdate=get_formation_evenements_presentiels($formation);
		$nbdate=pg_num_rows($resdate);
 		$nbcolonne = $nbdate + 1;//On ajoute 1 car il faut compte la cellule ou est place le libelle "Date".
 		
 		//On recupere les grilles correspondant  la formation
 		$resgrille=get_formation_grilles($formation);
		$nbgrille=pg_num_rows($resgrille);
		$rowgrille=pg_fetch_row($resgrille,0);
 		
 		//On injecte dans les variables du tpl.
 		$val['NOMBRE_COLONNE']=$nbcolonne;
 		$val['$MSG_971']=$MSG_971;
 		parent::set_var($val);
 		
 		//On boucle sur les grilles pour l'afficher dans le select.
 		parent::set_block('fin_contenu','block','block_select_grille');
 		for($g=0;$g<$nbgrille;$g++){
 			$rowgrille=pg_fetch_row($resgrille,$g);
 			$presentiel_contenu_fin_select = new guiFoPresentielContenuFinSelect($rowgrille[1],$rowgrille[0],$grille,$module_root,array('block_line'=>'gui_fo_presentiel_contenu_fin_select.tpl'));
 			$this->setComponent('block_line',$presentiel_contenu_fin_select,true,'block','block_select_grille');
 		}
 	}
 }
?>