<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class construit l'affichage du contenu du tableau de la grille,
 * Le libelle de la grille
 * La note de la grille
 * Les titres de capacits 
 * La ou les dates de capacits
 * Les capacits
 * Les cartons de capacits
 * 
 * @package presentiel
 */
  class guiFoPresentielContenuGrille extends PageComponent{
 	/**
 	 * Construit les objets necessaire  l'affichage du contenu du tableau de la grille
 	 * 
 	 * @param string $block_target Le nom de la variable qui contiendra la boucle dans le tpl.
 	 * @param string[] $tab Tableau comportant l'ensembles des notes presentielles d'un individu pour une grille.
 	 * @param string $libelle_grille Le libelle de la grille de l'individu
 	 * @param integer $grille L'identifiant de la grille
 	 * @param integer $individu L'identifiant d'individu
 	 * @param integer $formation L'identifiant de formation
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoPresentielContenuGrille($block_target,$tab,$libelle_grille,$grille,$individu,$formation,$module_root=null,$templates=null){
		global $chemin_fo,$s_langue; 
		global $MSG_650;		
 		parent::PageComponent($module_root,$templates);
 		
 		//On affiche le libelle de la grille avec la note de l'individu
 		$titre = new guiFoPresentielContenuGrilleLibelle($tab,$libelle_grille,$grille,$individu,$formation,$module_root,array('titre_grille'=>'gui_fo_presentiel_contenu_grille_libelle.tpl'));
 		$this->setComponent('titre_grille',$titre);
 		
 		$resdate=get_formation_evenements_presentiels($formation);
		$nbdate=pg_num_rows($resdate);
 		
 		//On boucle sur les dates
 		parent::set_block($block_target,'block_date','bloc_date');
 		for($d=0;$d<$nbdate;$d++){
			$rowdate=pg_fetch_row($resdate,$d);
			$t_date=explode(" ",$rowdate[2]);
			$tabd=explode("-",$t_date[0]);
			$dt=formater_date($tabd, $s_langue, $annee = 'y') ; 			
 			$val['LIBELLE_DATE']=$MSG_650;//"Date";
 			$presentiel_contenu_grille_date = new guiFoPresentielContenuGrilleDate($dt,$module_root,array('block_line_date'=>'gui_fo_presentiel_contenu_grille_date.tpl'));
 			$this->setComponent('block_line_date',$presentiel_contenu_grille_date,true,'block_date','bloc_date');
// 			$this->setComponent('block_line_date',$presentiel_contenu_grille_date,true,'block_date','bloc_date');
// 			$this->setComponent('block_line_date',$presentiel_contenu_grille_date,true,'block_date','bloc_date');
// 			$this->setComponent('block_line_date',$presentiel_contenu_grille_date,true,'block_date','bloc_date');
// 			$this->setComponent('block_line_date',$presentiel_contenu_grille_date,true,'block_date','bloc_date');
// 			$this->setComponent('block_line_date',$presentiel_contenu_grille_date,true,'block_date','bloc_date');
 		}
 		
 		parent::set_var($val);
 		
 		$restitre=get_grille_titrecapacites($grille);
		$nbtitre=pg_numrows($restitre);
 		
 	
 		//On boucle sur les titres capacites
 		parent::set_block($block_target,'block_titre','bloc_titre');
 		for($t=0;$t<$nbtitre;$t++){
			$rowtitre=pg_fetch_row($restitre,$t);
		    $notetitrecapacite=note_globale_titrecapacite($formation,$individu,$grille,$rowtitre[0],$tab); 
		    $notetitrecapacite *=100;
		    $notetitrecapacite=round($notetitrecapacite);
		    $notetitrecapacite /=100;

		    //on affiche les titres capacite	
 			$presentiel_contenu_grille_titre_capacite = new guiFoPresentielContenuGrilleTitreCapacite($tab,$nbdate,$resdate,$rowtitre[0],$rowtitre[1],$notetitrecapacite,$formation,$individu,$grille,$module_root,array('block_line_titre_capacites'=>'gui_fo_presentiel_contenu_grille_titre_capacite.tpl'));
 			$this->setComponent('block_line_titre_capacites',$presentiel_contenu_grille_titre_capacite,true,'block_titre','bloc_titre');
// 			$this->setComponent('block_line_titre_capacites',$presentiel_contenu_grille_titre_capacite,true,'block_titre','bloc_titre');
// 			$this->setComponent('block_line_titre_capacites',$presentiel_contenu_grille_titre_capacite,true,'block_titre','bloc_titre');
// 			$this->setComponent('block_line_titre_capacites',$presentiel_contenu_grille_titre_capacite,true,'block_titre','bloc_titre');
// 			$this->setComponent('block_line_titre_capacites',$presentiel_contenu_grille_titre_capacite,true,'block_titre','bloc_titre');
// 			$this->setComponent('block_line_titre_capacites',$presentiel_contenu_grille_titre_capacite,true,'block_titre','bloc_titre');
 		}
 	}
 }
?> 