<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche toutes les capacits ainsi que leur notes et construit l'affichage des cartons de couleur.
 * 
 * @package presentiel
 */
  class guiFoPresentielContenuGrilleCapacites extends PageComponent{
	/**
	 * Affichage des capacits et de leur notes et constructions de l'affichage des cartons de couleurs 
	 * correspondant aux notes.
	 * 
	 * @param integer $nbdate Le nombre de date de capacit
	 * @param integer[] $resdate L'ensemble des donnes retourner par la fonction et_formation_evenements_presentiels($formation)
	 * @param integer $num_titre L'identifiant du titre de capacit
	 * @param integer $num_capa L'identifiant de la capacit
	 * @param libelle $libelle_titre Le libelle du titre capacit
 	 * @param integer $formation L'identifant de formation
 	 * @param integer $individu L'identifant d'individu
 	 * @param integer $grille L'identifiant de la grille
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoPresentielContenuGrilleCapacites($nbdate,$resdate,$num_titre,$num_capa,$libelle_titre,$formation,$individu,$grille,$module_root=null,$templates=null){
		global $chemin_fo; 		
 		parent::PageComponent($module_root,$templates);
 		
 		$rec_notes=get_presentiel_resultats_individu_capacite($formation,$individu,$grille,$num_titre,$num_capa);
 		$row_note = pg_fetch_row($rec_notes);
 		//print_rr($row_notes);
 		$val['LIBELLE_CAPACITE']=get_fo_libelle($libelle_titre);
 		if(!empty($row_note[6]) && !empty($row_note[7]) )
 			$val['CAPACITE_NOTE']="($row_note[6]/$row_note[7])";
 		else
 			$val['CAPACITE_NOTE']="(0/0)";
 		
 		//Ici on bouclera sur les cartons 
 		parent::set_block('block_line','block','bloc_carton');
 		 for($d=0;$d<$nbdate;$d++){
	        $rowdate=pg_fetch_row($resdate,$d);
			$res_resultat=get_presentiel_resultat_individu_date( $formation,$individu,$grille,$num_titre,$num_capa,$rowdate[2]);
			$row_resultat=pg_fetch_row($res_resultat);
			//print_rr($row_resultat);
			// Prise en compte de l'absence de carton
			if($row_resultat[8]){
				$presentiel_contenu_grille_cartons = new guiFoPresentielContenuGrilleCartons($row_resultat[5],$row_resultat[6],$row_resultat[7],$row_resultat[8],$module_root,array('block_line'=>'gui_fo_presentiel_contenu_grille_cartons.tpl'));
				$this->setComponent('block_line',$presentiel_contenu_grille_cartons,true,'block','bloc_carton');
			}
			else{
				$presentiel_contenu_grille_cartons= new guiFoPresentielContenuGrilleSansCarton($module_root,array('block_line'=>'gui_fo_presentiel_contenu_grille_sans_carton.tpl'));
				$this->setComponent('block_line',$presentiel_contenu_grille_cartons,true,'block','bloc_carton');	
			}
			
		}
 		parent::set_var($val);
 	}
 }
?>