<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cette class affiche les differents cartons de la grille appartenant  une notation
 * 
 * @package presentiel
 */
  class guiFoPresentielContenuGrilleCartons extends PageComponent{
 	/**
 	 * Affichage des cartons multicouleur
 	 * 
 	 * @param string[] $row_resultat5 L'ensemble des commentaires placs dans les BULLES
 	 * @param string[] $row_resultat6 L'ensemble des notes capacits placs dans les BULLES
 	 * @param string[] $row_resultat7 L'ensemble des bareme de notation placs dans les BULLES
 	 * @param integer[] $row_resultat8 L'ensemble des identifiant d'image des cartons 
 	 * @param string $module_root Le chemin du dossier contenant les tpl requis
 	 * @param string[] $templates Le tableau contenant la variable de destination et le tpl requis pour l'objet
 	 */
 	function guiFoPresentielContenuGrilleCartons($row_resultat5,$row_resultat6,$row_resultat7,$row_resultat8,$module_root=null,$templates=null){
		global $chemin_fo; 
		global $MSG_2505;//Message de langue (Pas encore not)		
 		parent::PageComponent($module_root,$templates);

 			//row_resultat5 => commentaire des bulles
 			//row_resultat6 => Note place dans les bulles
 			//$row_resultat7 => Les bareme de notation
 			//$row_resultat8 => Les numeros d'image des cartons

 			//initialisation du commentaire
 			$commentaire="";
 			//initialisation de la note
 			$note="";
 			//initialisation de la notesur
 			$notesur=""; 
		   
		   if($row_resultat8>0){
				if($row_resultat5!=""){
						$commentaire=$row_resultat5;
						$note=$row_resultat6;
						$notesur=$row_resultat7;
						if(!is_null($commentaire))
							$commentaire=nl2br($commentaire);
						else
							$commentaire="";
				}else{
						unset($commentaire);
						unset($note);
						unset($notesur);
				}
				$couleur_bulle="#ffcc00";
				//switch($tabval["$row_resultat[8]"]){
				$commentaire=get_fo_libelle($commentaire);
				switch($row_resultat8){
					// on affiche la couleur du carton corresepondant
					case "A":
					case 3 :
						$val['URL_IMAGE']=3;
						if($row_resultat5!="")
							$val['COMMENTAIRE']="$commentaire ($note/$notesur)";
						else
							$val['COMMENTAIRE']=$MSG_2505;
					break;

					case "EC":
					case 2 :
						$val['URL_IMAGE']=2;
						if($row_resultat5!="")
							$val['COMMENTAIRE']="$commentaire ($note/$notesur)";
						else
							$val['COMMENTAIRE']=$MSG_2505;
					break;

					case "NA":
					case 1 :
						$val['URL_IMAGE']=1;
						if($row_resultat5!="")
							$val['COMMENTAIRE']="$commentaire ($note/$notesur)";
						else
							$val['COMMENTAIRE']=$MSG_2505;
						
					break;
					default:
					
				}
		   }
		   else {
		   		// traitement si pas de carton
		   }
 		parent::set_var($val);
 	}
 }
?>